/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.database.tool.access;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.database.tool.access.SqlScalars;
import com.valor.mfc.vms.common.database.tool.access.constants.EOperator;
import com.valor.mfc.vms.common.database.tool.access.constants.ESqlOrder;
import common.base.tools.type.CollectionUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseDao.class);

    public abstract Session currentSession();

    public void flushAndClear() {
        Session session = this.currentSession();
        session.flush();
        session.clear();
    }

    public void storeEntity(Object entity) {
        if (entity != null) {
            if (entity instanceof AbstractLMI) {
                ((AbstractLMI)entity).setLastModifyTime(new Date());
            }
            this.currentSession().saveOrUpdate(entity);
        }
    }

    public void storeEntityIfAbsent(Object entity) {
        Session session = this.currentSession();
        this.doStoreEntityIfAbsent(entity, session);
    }

    private void doStoreEntityIfAbsent(Object entity, Session session) {
        boolean exists = session.contains(entity);
        if (!exists) {
            session.saveOrUpdate(entity);
        }
    }

    public Object mergeEntity(Object entity) {
        return this.currentSession().merge(entity);
    }

    public void mergeAll(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            for (Object entity : entities) {
                session.merge(entity);
            }
        }
    }

    public void storeAll(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            for (Object entity : entities) {
                session.saveOrUpdate(entity);
            }
        }
    }

    public void storeAllIfAbsent(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            for (Object entity : entities) {
                this.doStoreEntityIfAbsent(entity, session);
            }
        }
    }

    public void deleteAll(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            for (Object entity : entities) {
                session.delete(entity);
            }
        }
    }

    public void saveEntity(Object entity) {
        this.currentSession().save(entity);
    }

    public void updateEntity(Object entity) {
        this.currentSession().update(entity);
    }

    public void deleteEntity(Object entity) {
        this.currentSession().delete(entity);
    }

    public <T> T getById(Class<T> entityClass, Serializable id) {
        return (T)this.currentSession().get(entityClass, id);
    }

    public <T> T getByNaturalId(Class<? extends T> entityClass, String field, String name) {
        return (T)this.currentSession().byNaturalId(entityClass).using(field, (Object)name).load();
    }

    public <T> T getByNaturalIdCaseInsensitive(Class<? extends T> entityClass, String field, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("from ");
        sb.append(entityClass.getSimpleName());
        sb.append(" where lower(").append(field).append(") = :name) { ");
        Map<String, Object> params = Collections.singletonMap("name", name.toLowerCase());
        return (T)this.findUniqueByNamedParameters(sb, params);
    }

    protected static String convertRowElementToString(Object rowElement) {
        if (rowElement == null) {
            return null;
        }
        if (rowElement instanceof String) {
            return (String)rowElement;
        }
        return rowElement.toString();
    }

    protected static Integer convertRowElementToInteger(Object rowElement) {
        if (rowElement == null) {
            return 0;
        }
        if (StringUtils.isNumeric((CharSequence)rowElement.toString())) {
            return Integer.valueOf(rowElement.toString());
        }
        return 0;
    }

    protected static Long convertRowElementToLong(Object rowElement) {
        if (rowElement == null) {
            return 0L;
        }
        if (StringUtils.isNumeric((CharSequence)rowElement.toString())) {
            return Long.valueOf(rowElement.toString());
        }
        return 0L;
    }

    protected static Date convertRowElementToDate(Object rowElement) {
        if (rowElement == null) {
            return null;
        }
        if (rowElement instanceof Date) {
            return (Date)rowElement;
        }
        return null;
    }

    protected static Timestamp convertRowElementToTimestamp(Object rowElement) {
        if (rowElement == null) {
            return null;
        }
        if (rowElement instanceof Timestamp) {
            return (Timestamp)rowElement;
        }
        return null;
    }

    protected static BigDecimal convertRowElementToBigDecimal(Object rowElement) {
        if (rowElement == null) {
            return BigDecimal.ZERO;
        }
        if (rowElement instanceof BigDecimal) {
            return (BigDecimal)rowElement;
        }
        return new BigDecimal(rowElement.toString());
    }

    protected static void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else if (value instanceof String) {
            queryObject.setString(paramName, (String)value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    public List find(CharSequence queryString) {
        Query queryObject = this.currentSession().createQuery(queryString.toString());
        queryObject.setCacheable(true);
        return queryObject.list();
    }

    public List findById(CharSequence queryString, Long id) {
        Query queryObject = this.currentSession().createQuery(queryString.toString());
        queryObject.setCacheable(true);
        queryObject.setParameter("id", (Object)id);
        return queryObject.list();
    }

    public List findByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            AbstractBaseDao.applyNamedParameterToQuery(query, param.getKey(), param.getValue());
        }
        return query.list();
    }

    public Object findUniqueByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            AbstractBaseDao.applyNamedParameterToQuery(query, param.getKey(), param.getValue());
        }
        return query.uniqueResult();
    }

    public int executeUpdate(CharSequence queryCharSequence) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        return query.executeUpdate();
    }

    public int executeUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            AbstractBaseDao.applyNamedParameterToQuery(query, param.getKey(), param.getValue());
        }
        return query.executeUpdate();
    }

    public int executeSqlUpdate(CharSequence queryCharSequence) {
        SQLQuery query = this.currentSession().createSQLQuery(queryCharSequence.toString());
        query.setCacheable(true);
        return query.executeUpdate();
    }

    public int executeSqlUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        SQLQuery query = this.currentSession().createSQLQuery(queryCharSequence.toString());
        query.setCacheable(true);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            AbstractBaseDao.applyNamedParameterToQuery((Query)query, param.getKey(), param.getValue());
        }
        return query.executeUpdate();
    }

    private void setResultTransformer(Class T, SQLQuery query) {
        if (!(T == null || T.equals(String.class) || T.equals(Long.class) || T.equals(Integer.class) || T.equals(Object[].class))) {
            query.setResultTransformer(Transformers.aliasToBean((Class)T));
        }
    }

    public <T> List<T> query(Class T, SqlScalars sqlScalars, int firstResult, int maxResult) {
        SQLQuery query = sqlScalars.createSqlQuery(this.currentSession());
        query.setReadOnly(true);
        this.setResultTransformer(T, query);
        sqlScalars.populateScalars(query);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResult);
        return query.list();
    }

    public List getDataList(boolean enableCache, Class returnType, Map<EOperator, Map<String, Object>> filters) {
        return Lists.newArrayList();
    }

    public List getListData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return this.getListData(enableCache, true, returnType, filters);
    }

    public <T> List<T> getListData(boolean enableCache, boolean readOnly, Class returnType, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(returnType);
        criteria.setReadOnly(readOnly);
        criteria.setCacheable(enableCache);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        List list = criteria.list();
        return list;
    }

    public List getListDataIn(boolean enableCache, Class returnType, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(returnType);
        criteria.setReadOnly(true);
        criteria.setCacheable(enableCache);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Object[])((Collection)entry.getValue()).toArray()));
                    continue;
                }
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        List list = criteria.list();
        return list;
    }

    public Set getSetData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return new HashSet(this.getListData(enableCache, returnType, filters));
    }

    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(returnType);
        criteria.setReadOnly(true);
        criteria.setCacheable(enableCahce);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        return criteria.uniqueResult();
    }

    public int excuteSql(String sql) {
        return this.currentSession().createSQLQuery(sql).executeUpdate();
    }

    public int excuteQueryCount(String sql) {
        try {
            return ((BigInteger)this.currentSession().createSQLQuery(sql).uniqueResult()).intValue();
        }
        catch (Exception e) {
            logger.info("query count exception! sql={} exception:{}", (Object)sql, (Object)e);
            return -1;
        }
    }

    public long criteriaQueryCount(Class valueType) {
        return this.criteriaQueryCount(valueType, false);
    }

    public long criteriaQueryCount(Class valueType, boolean cacheable) {
        Long ret = (Long)this.currentSession().createCriteria(valueType).setReadOnly(true).setCacheable(cacheable).setProjection(Projections.rowCount()).uniqueResult();
        return ret;
    }

    public long criteriaQueryCount(Class valueType, Map<String, Object> filter) {
        Criteria criteria = this.currentSession().createCriteria(valueType);
        if (filter != null) {
            for (Map.Entry<String, Object> entry : filter.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)((Collection)entry.getValue())));
                    continue;
                }
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        criteria.setProjection(Projections.rowCount());
        Long ret = (Long)criteria.uniqueResult();
        return ret;
    }

    public List getPageData(Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        return this.getPageData(false, returnType, filters, order, firstResult, maxResult);
    }

    public List getPageData(boolean cacheable, Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        Criteria criteria = this.currentSession().createCriteria(returnType);
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResult);
        criteria.setReadOnly(true);
        criteria.setCacheable(cacheable);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        if (!CollectionUtils.isNullOrEmpty(order)) {
            order.forEach((k, v) -> {
                if (v == ESqlOrder.ASC) {
                    criteria.addOrder(Order.asc((String)k));
                } else if (v == ESqlOrder.DESC) {
                    criteria.addOrder(Order.desc((String)k));
                }
            });
        }
        List list = criteria.list();
        return list;
    }

    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)((Collection)entry.getValue())));
                    continue;
                }
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.max((String)"lastModifyTime")));
        Date lastModifyTime = (Date)criteria.uniqueResult();
        if (lastModifyTime == null) {
            return "";
        }
        return String.valueOf(lastModifyTime.getTime());
    }

    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)((Collection)entry.getValue())));
                    continue;
                }
                criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.max((String)"lastModifyTime")));
        return (Date)criteria.uniqueResult();
    }

    public String queryDBStamp(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        criteria.setCacheable(false);
        criteria.setReadOnly(true);
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.count((String)"last_modify_time")).add((Projection)Projections.max((String)"last_modify_time")));
        Object[] objList = (Object[])criteria.uniqueResult();
        if (objList == null) {
            return "";
        }
        return Joiner.on((String)"@").useForNull("-").join(objList);
    }
}

