/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.database.tool.configruation;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.model.TableShardingParams;
import common.config.tools.config.ConfigTools3;
import io.shardingsphere.core.api.ShardingDataSourceFactory;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.api.config.TableRuleConfiguration;
import io.shardingsphere.core.api.config.strategy.InlineShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.ShardingStrategyConfiguration;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public abstract class AbstractDBCfgWithSharding {
    protected Boolean showSql = false;

    protected abstract DataSource createDataSouce();

    protected abstract List<TableShardingParams> configureTableShardingParams();

    protected abstract String configureDatabaseName();

    private List<TableRuleConfiguration> getTableRules() {
        ArrayList<TableRuleConfiguration> rules = new ArrayList<TableRuleConfiguration>();
        List<TableShardingParams> tableShardingParams = this.configureTableShardingParams();
        if (tableShardingParams != null && tableShardingParams.size() > 0) {
            for (TableShardingParams params : tableShardingParams) {
                TableRuleConfiguration rule = new TableRuleConfiguration();
                rule.setLogicTable(params.getTableName());
                rule.setActualDataNodes(params.getActualDataNodesExpression());
                rule.setTableShardingStrategyConfig((ShardingStrategyConfiguration)new InlineShardingStrategyConfiguration(params.getShardingColumn(), params.getStrategyExpression()));
                rules.add(rule);
            }
        }
        return rules;
    }

    @Primary
    @Bean(name={"shardingDataSource"})
    public DataSource getShardingDataSource() throws SQLException {
        ShardingRuleConfiguration shardingRuleConfig = new ShardingRuleConfiguration();
        List<TableRuleConfiguration> tableRules = this.getTableRules();
        if (tableRules != null && tableRules.size() > 0) {
            shardingRuleConfig.getTableRuleConfigs().addAll(tableRules);
        }
        Properties p = new Properties();
        if (this.showSql.booleanValue()) {
            p.setProperty("sql.show", "true");
        }
        return ShardingDataSourceFactory.createDataSource(this.createDataSourceMap(), (ShardingRuleConfiguration)shardingRuleConfig, new HashMap(), (Properties)p);
    }

    private Map<String, DataSource> createDataSourceMap() {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(1, 1.0f);
        DataSource dataSouce = this.createDataSouce();
        if (dataSouce == null) {
            throw new RuntimeException("Datasource is not properly configured!");
        }
        result.put(this.configureDatabaseName(), dataSouce);
        return result;
    }

    protected String getDBConfig(String configKey, String cryptKey) {
        if (Strings.isNullOrEmpty((String)cryptKey)) {
            return ConfigTools3.getString((String)configKey);
        }
        return this.getDBConfig(configKey, cryptKey);
    }
}

