/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.service;

import com.valor.mfc.vms.common.service.IChangedProcessor;
import com.valor.mfc.vms.common.service.IChangedRunner;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedRunner
implements IChangedRunner {
    private static final Logger logger = LoggerFactory.getLogger(ChangedRunner.class);
    private BlockingQueue queue;
    private IChangedProcessor changedProcessor;

    public ChangedRunner(BlockingQueue queue, IChangedProcessor changedProcessor) {
        this.queue = queue;
        this.changedProcessor = changedProcessor;
        if (this.changedProcessor == null) {
            throw new IllegalArgumentException("Processor is null.");
        }
    }

    @Override
    public void run() {
        Object element = this.queue.poll();
        while (element != null) {
            try {
                this.changedProcessor.onStart(element);
                this.changedProcessor.onChanged(element);
            }
            catch (Exception e) {
                this.changedProcessor.onError(element, e);
            }
            finally {
                this.changedProcessor.onEnd(element);
            }
            element = this.queue.poll();
        }
    }
}

