/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.service;

import com.valor.mfc.vms.common.service.ChangedRunner;
import com.valor.mfc.vms.common.service.IChangedProcessor;
import com.valor.mfc.vms.common.service.IChangedScanner;
import com.valor.mfc.vms.common.tools.sys.ThreadRunTool;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedScanRunner {
    private static final Logger logger = LoggerFactory.getLogger(ChangedScanRunner.class);
    private IChangedScanner scanner;
    private IChangedProcessor processor;
    private String scannerName = "";

    public ChangedScanRunner(String scannerName, IChangedScanner scanner, IChangedProcessor processor) {
        this.scanner = scanner;
        this.processor = processor;
        this.scannerName = scannerName;
    }

    public void run(int maxResult, int maxThreads, int waitMS) {
        this.run(maxResult, maxThreads, waitMS, true);
    }

    public void run(int maxResult, int maxThreads, int waitMS, boolean printIfNoData) {
        BlockingQueue queue = this.scanner.getChanged(maxResult);
        if (Objects.nonNull(queue) && queue.size() > 0) {
            logger.info("[{}] is running with records[{}-{}].", new Object[]{this.scannerName, maxResult, queue.size()});
            ThreadRunTool.runThreads(maxThreads, waitMS, new ChangedRunner(queue, this.processor));
        } else if (printIfNoData) {
            logger.info("[{}] no records need process.", (Object)this.scannerName);
        }
    }
}

