/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.tools.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    public static final int DEFAULT_MAX_SIZE = 100;
    private final Map<K, V> internal;

    public LRUCache() {
        this(100);
    }

    public LRUCache(final int maxSize) {
        this.internal = Collections.synchronizedMap(new LinkedHashMap<K, V>(maxSize + 1, 0.75f, true){
            private static final long serialVersionUID = 4464242524720551192L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxSize;
            }
        });
    }

    public V put(K key, V value) {
        return this.internal.put(key, value);
    }

    public V get(K key) {
        return this.internal.get(key);
    }
}

