package com.valor.mfc.vms.common.database.tool.configruation;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;

import static java.sql.Connection.TRANSACTION_READ_COMMITTED;

/**
 * Created by Frank.Huang on 2016/4/23.
 */
public abstract class AbstractDBCfgWithDBCP2 extends AbstractDBCfg {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBCfgWithDBCP2.class);

    protected boolean poolPreparedStatements = ConfigTools3.getBoolean("db.pool.poolPreparedStatements", true);
    protected int initialSize = ConfigTools3.getInt("db.pool.initialSize", 10);
    protected int maxActive = ConfigTools3.getInt("db.pool.maxActive", 500);
    protected int minIdle = ConfigTools3.getInt("db.pool.minIdle", 10);
    protected int maxIdle = ConfigTools3.getInt("db.pool.maxIdle", 20);
    protected long maxWait = ConfigTools3.getInt("db.pool.maxWait", 20);
    protected long minEvictableIdleTimeMillis = ConfigTools3.getInt("db.pool.minEvictableIdleTimeMillis", 60000);
    protected long timeBetweenEvictionRunsMillis = ConfigTools3.getInt("db.pool.timeBetweenEvictionRunsMillis", 60000);
    protected int numTestsPerEvictionRun = ConfigTools3.getInt("db.pool.numTestsPerEvictionRun", 50);
    protected boolean testOnBorrow = ConfigTools3.getBoolean("db.pool.testOnBorrow", true);
    protected boolean testWhileIdle = ConfigTools3.getBoolean("db.pool.testWhileIdle", true);
    protected boolean testOnReturn = ConfigTools3.getBoolean("db.pool.testOnReturn", true);
    protected boolean logAbandoned = ConfigTools3.getBoolean("db.pool.logAbandoned", true);
    protected boolean removeAbandonedOnBorrow = ConfigTools3.getBoolean("db.pool.removeAbandonedOnBorrow", true);
    protected boolean removeAbandonedOnMaintenance = ConfigTools3.getBoolean("db.pool.removeAbandonedOnBorrow", true);
    protected int removeAbandonedTimeout = ConfigTools3.getInt("db.pool.removeAbandonedTimeout", 120);

//    protected boolean useL2Cache = ConfigTools3.getBoolean("db.l2cache.useL2Cache", false);
//    protected boolean useQueryCache = ConfigTools3.getBoolean("db.l2cache.pool.useQueryCache", false);
//    protected String l2CacheFactory = ConfigTools3.getString("db.l2cache.l2CacheFactory", "org.hibernate.cache.ehcache.EhCacheRegionFactory");

    @Override
    public DataSource getDataSource(String dbURL, String username, String password) {
        if (Strings.isNullOrEmpty(dbURL)) {
            throw new IllegalArgumentException("DB Url is empty");
        }

        if (Strings.isNullOrEmpty(username)) {
            throw new IllegalArgumentException("DB user is empty");
        }

        if (Strings.isNullOrEmpty(password)) {
            throw new IllegalArgumentException("DB password is empty");
        }

        BasicDataSource datasource = new BasicDataSource();
        datasource.setUrl(dbURL);
        datasource.setUsername(username);
        datasource.setPassword(password);

        datasource.setDriverClassName(driverClassName);
        datasource.setValidationQuery(validationQuery);
        datasource.setPoolPreparedStatements(poolPreparedStatements);
        datasource.setInitialSize(initialSize);
        datasource.setMaxTotal(maxActive);
        datasource.setMinIdle(minIdle);
        datasource.setMaxIdle(maxIdle);
        datasource.setMaxWaitMillis(maxWait);
        datasource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        datasource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        datasource.setNumTestsPerEvictionRun(numTestsPerEvictionRun);

        datasource.setLogAbandoned(logAbandoned);
        datasource.setRemoveAbandonedOnBorrow(removeAbandonedOnBorrow);
        datasource.setRemoveAbandonedOnMaintenance(removeAbandonedOnMaintenance);
        datasource.setRemoveAbandonedTimeout(removeAbandonedTimeout);

        datasource.setTestOnBorrow(testOnBorrow);
        datasource.setTestWhileIdle(testWhileIdle);
        datasource.setTestOnReturn(testOnReturn);

        datasource.setDefaultTransactionIsolation(TRANSACTION_READ_COMMITTED);
        return datasource;
    }

//    public Properties getDBProperties() {
//        Properties props = new Properties();
//
//        props.put("hibernate.dialect", dialect);
//        props.put("hibernate.show_sql", showSql);
//        props.put("hibernate.format_sql", false);
//        props.put("hibernate.generate_statistics", generateStatistics);
//        props.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);
//        props.put("hibernate.connection.isolation", TRANSACTION_READ_COMMITTED);
//        props.put("hibernate.use_sql_comments", true);
//
//        props.put("hibernate.cache.use_second_level_cache", false);
//        props.put("hibernate.cache.use_query_cache", false);
//        props.put("hibernate.connection.CharSet", "utf8");
//        props.put("hibernate.connection.characterEncoding", "utf8");
//        props.put("hibernate.connection.useUnicode", true);
//        props.put("hibernate.autoReconnect", true);
//        return props;
//    }

//    public FactoryBean<SessionFactory> getSessionFactory(
//            DataSource dataSource, String... scanPackages) {
//        Properties props = getDBProperties();
//        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
//        sessionFactoryBean.setEntityInterceptor(new AuditInterceptor());
//        sessionFactoryBean.setDataSource(dataSource);
//        sessionFactoryBean.setPackagesToScan(scanPackages);
//        sessionFactoryBean.setHibernateProperties(getDBProperties());
//        // sessionFactoryBean.setNamingStrategy();
//
//        return sessionFactoryBean;
//    }

//    public PlatformTransactionManager getTransactionManager(
//            SessionFactory sessionFactory, int txTimeout) throws Exception {
//        HibernateTransactionManager transactionManager =
//                new HibernateTransactionManager(sessionFactory);
//        transactionManager.setDefaultTimeout(txTimeout);
//        return transactionManager;
//    }
//
//    public String getConnectUrl(String host, String inst) {
//        if (Strings.isNullOrEmpty(host) || Strings.isNullOrEmpty(inst)) {
//            return "";
//        }
//
//        return String.format("jdbc:mysql://%s/%s?useUnicode=true&characterEncoding=utf8&autoReconnect=true", host, inst);
//    }
}
