package com.valor.mfc.vms.common.database.tool.configruation;

import com.zaxxer.hikari.HikariDataSource;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;

/**
 * Created by Frank.Huang on 2016/4/23.
 */
public abstract class AbstractDBCfgWithHikariCP extends AbstractDBCfg {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBCfgWithHikariCP.class);


    @Override
    public DataSource getDataSource(String dbURL, String username, String password) {
        /**
         * https://github.com/brettwooldridge/HikariCP/wiki/MySQL-Configuration
         */
        final HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(dbURL);
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setConnectionInitSql(ConfigTools3.getString("db.connectionInitSql", "set names utf8mb4;" ));

        ds.setMaximumPoolSize(ConfigTools3.getInt("db.HikariCP.maxActive", 10));
        ds.setMinimumIdle(ConfigTools3.getInt("db.HikariCP.minIdle", 10));

        ds.addDataSourceProperty("cachePrepStmts", ConfigTools3.getBoolean("db.HikariCP.cachePrepStmts", true));
        ds.addDataSourceProperty("prepStmtCacheSize", ConfigTools3.getInt("db.HikariCP.prepStmtCacheSize", 250));
        ds.addDataSourceProperty("prepStmtCacheSqlLimit", ConfigTools3.getInt("db.HikariCP.prepStmtCacheSqlLimit", 2048));
        ds.addDataSourceProperty("useServerPrepStmts", ConfigTools3.getBoolean("db.HikariCP.useServerPrepStmts", true));
        ds.addDataSourceProperty("useLocalSessionState", ConfigTools3.getBoolean("db.HikariCP.useLocalSessionState", true));
        ds.addDataSourceProperty("rewriteBatchedStatements", ConfigTools3.getBoolean("db.HikariCP.rewriteBatchedStatements", true));
        ds.addDataSourceProperty("cacheResultSetMetadata", ConfigTools3.getBoolean("db.HikariCP.cacheResultSetMetadata", true));
        ds.addDataSourceProperty("cacheResultSetMetadata", ConfigTools3.getBoolean("db.HikariCP.cacheResultSetMetadata", true));
        ds.addDataSourceProperty("elideSetAutoCommits", ConfigTools3.getBoolean("db.HikariCP.elideSetAutoCommits", true));
        ds.addDataSourceProperty("maintainTimeStats", ConfigTools3.getBoolean("db.HikariCP.elideSetAutoCommits", true));

        logger.info(String.format("[HikariCP]Max:%s Min:%s Properties:%s", ds.getMaximumPoolSize(), ds.getMinimumIdle(), ds.getDataSourceProperties().toString()));
        return ds;
    }
}
