package com.valor.mfc.vms.common.tools.sys;

import com.valor.mfc.vms.common.service.ChangedScanRunner2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * Created by Frank.Huang on 2016/4/16.
 */
public class ThreadRunTool {
    private static final Logger logger = LoggerFactory.getLogger(ThreadRunTool.class);
    public static void runThreads(int maxThreads, int waitMS, Runnable runnable){
        logger.info("ThreadRunTool startTime[{}].",System.currentTimeMillis());
        ExecutorService executor = Executors.newFixedThreadPool(maxThreads);

        for (int i = 0; i<maxThreads; i++){
            executor.execute(runnable);
        }
        executor.shutdown();

        // run until all workers have finished
        while (!executor.isTerminated()) {
            try {
                if (waitMS<=0){
                    waitMS = 500;
                }
                TimeUnit.MILLISECONDS.sleep(waitMS);
            } catch (InterruptedException ignore) {
                // ignore error which is expected
            }
        }
        logger.info("ThreadRunTool endTime[{}].", System.currentTimeMillis());
    }
}
