/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.cache.redis;

import com.alibaba.fastjson.JSON;
import com.valor.mfc.vms.common.cache.redis.FastJsonRedisSerializer;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class MFCRedisConfig
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(MFCRedisConfig.class);
    int dbIndex = ConfigTools3.getInt((String)"spring.redis.database", (Integer)0);
    String host = ConfigTools3.getString((String)"spring.redis.host", (String)"");
    int port = ConfigTools3.getInt((String)"spring.redis.port", (Integer)0);
    String password = ConfigTools3.getString((String)"spring.redis.password", (String)"");
    int timeout = ConfigTools3.getInt((String)"spring.redis.timeout", (Integer)0);

    @Bean(name={"mfcRedisConnectionFactory"})
    @Qualifier(value="mfcRedisConnectionFactory")
    @Primary
    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.createJedisConnectionFactory(this.dbIndex, this.host, this.port, this.password, this.timeout);
    }

    @Bean
    public CacheErrorHandler errorHandler() {
        return new RedisCacheErrorHandler();
    }

    public JedisConnectionFactory createJedisConnectionFactory(int dbIndex, String host, int port, String password, int timeout) {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        jedisConnectionFactory.setDatabase(dbIndex);
        jedisConnectionFactory.setHostName(host);
        jedisConnectionFactory.setPort(port);
        jedisConnectionFactory.setPassword(password);
        jedisConnectionFactory.setTimeout(timeout);
        int redisPoolMaxIdle = ConfigTools3.getInt((String)"spring.redis.pool.max-idle", (Integer)8);
        int redisPoolMinIdle = ConfigTools3.getInt((String)"spring.redis.pool.min-idle", (Integer)0);
        int redisPoolMaxActive = ConfigTools3.getInt((String)"spring.redis.pool.max-active", (Integer)8);
        int redisPoolMaxWait = ConfigTools3.getInt((String)"spring.redis.pool.max-wait", (Integer)-1);
        jedisConnectionFactory.setPoolConfig(this.setPoolConfig(redisPoolMaxIdle, redisPoolMinIdle, redisPoolMaxActive, redisPoolMaxWait, true));
        return jedisConnectionFactory;
    }

    public JedisPoolConfig setPoolConfig(int maxIdle, int minIdle, int maxActive, int maxWait, boolean testOnBorrow) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMinIdle(minIdle);
        poolConfig.setMaxTotal(maxActive);
        poolConfig.setMaxWaitMillis((long)maxWait);
        poolConfig.setTestOnBorrow(testOnBorrow);
        return poolConfig;
    }

    @Bean
    public RedisCacheManager cacheManager(RedisTemplate redisTemplate) {
        RedisCacheManager redisCacheManager = new RedisCacheManager((RedisOperations)redisTemplate);
        redisCacheManager.setUsePrefix(true);
        Long expiredTime = ConfigTools3.getLong((String)"mfc.redis.cache.expire.time", (Long)7200L);
        redisCacheManager.setDefaultExpiration(expiredTime.longValue());
        return redisCacheManager;
    }

    @Bean(name={"cacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName()).append(".");
            sb.append(method.getName()).append(".");
            for (Object obj : params) {
                sb.append(JSON.toJSONString((Object)obj).hashCode());
            }
            return sb.toString();
        };
    }

    @Bean(name={"redisTemplate"})
    @Primary
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        FastJsonRedisSerializer<Object> fastJsonRedisSerializer = new FastJsonRedisSerializer<Object>(Object.class);
        redisTemplate.setValueSerializer(fastJsonRedisSerializer);
        redisTemplate.setHashValueSerializer(fastJsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    private static class RedisCacheErrorHandler
    extends SimpleCacheErrorHandler {
        private RedisCacheErrorHandler() {
        }

        public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
            log.error("handleCacheGetError key = {}, value = {}", key, (Object)cache);
            log.error("cache get error", (Throwable)exception);
        }

        public void handleCachePutError(RuntimeException exception, Cache cache, Object key, Object value) {
            log.error("handleCachePutError key = {}, value = {}", key, (Object)cache);
            log.error("cache put error", (Throwable)exception);
        }

        public void handleCacheEvictError(RuntimeException exception, Cache cache, Object key) {
            log.error("handleCacheEvictError key = {}, value = {}", key, (Object)cache);
            log.error("cache evict error", (Throwable)exception);
        }

        public void handleCacheClearError(RuntimeException exception, Cache cache) {
            log.error("handleCacheClearError value = {}", (Object)cache);
            log.error("cache clear error", (Throwable)exception);
        }
    }
}

