/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.database.tool.configruation;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AuditInterceptor;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDBCfg {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBCfg.class);
    protected String driverClassName = ConfigTools3.getString((String)"db.driverClassName", (String)"com.mysql.cj.jdbc.Driver");
    protected String dialect = ConfigTools3.getString((String)"db.dialect", (String)"org.hibernate.dialect.MySQL5Dialect");
    protected String validationQuery = ConfigTools3.getString((String)"db.validationQuery", (String)"SELECT 1");
    protected String hbm2ddlAuto = ConfigTools3.getString((String)"db.hbm2ddlAuto", (String)"update");
    protected boolean showSql = ConfigTools3.getBoolean((String)"db.stat.showSql", (boolean)false);
    protected boolean generateStatistics = ConfigTools3.getBoolean((String)"db.stat.generateStatistics", (boolean)false);
    protected boolean useL2Cache = ConfigTools3.getBoolean((String)"db.l2cache.useL2Cache", (boolean)false);
    protected boolean useQueryCache = ConfigTools3.getBoolean((String)"db.l2cache.pool.useQueryCache", (boolean)false);
    protected String l2CacheFactory = ConfigTools3.getString((String)"db.l2cache.l2CacheFactory", (String)"org.hibernate.cache.ehcache.EhCacheRegionFactory");

    public abstract DataSource getDataSource(String var1, String var2, String var3);

    public Properties getDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.show_sql", (Object)this.showSql);
        props.put("hibernate.format_sql", (Object)false);
        props.put("hibernate.generate_statistics", (Object)this.generateStatistics);
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        props.put("hibernate.connection.isolation", (Object)2);
        props.put("hibernate.use_sql_comments", (Object)true);
        props.put("hibernate.cache.use_second_level_cache", (Object)false);
        props.put("hibernate.cache.use_query_cache", (Object)false);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", (Object)true);
        props.put("hibernate.autoReconnect", (Object)true);
        return props;
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource, String ... scanPackages) {
        Properties props = this.getDBProperties();
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setEntityInterceptor((Interceptor)new AuditInterceptor());
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setPackagesToScan(scanPackages);
        sessionFactoryBean.setHibernateProperties(this.getDBProperties());
        return sessionFactoryBean;
    }

    public PlatformTransactionManager getTransactionManager(SessionFactory sessionFactory, int txTimeout) throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(sessionFactory);
        transactionManager.setDefaultTimeout(txTimeout);
        return transactionManager;
    }

    public String getConnectUrl(String host, String inst) {
        if (Strings.isNullOrEmpty((String)host) || Strings.isNullOrEmpty((String)inst)) {
            return "";
        }
        return String.format("jdbc:mysql://%s/%s?useUnicode=true&characterEncoding=utf8&autoReconnect=true", host, inst);
    }

    protected String getDBConfig(String configKey, String cryptKey) {
        return Strings.isNullOrEmpty((String)cryptKey) ? ConfigTools3.getString((String)configKey) : ConfigAESTools.getAESString((String)configKey, (String)cryptKey);
    }
}

