/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.tools.meta;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.base.tools.type.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageTools {
    private static final Logger logger = LoggerFactory.getLogger(LanguageTools.class);
    public static String LANG_PT = "pt";
    public static String LANG_ES = "es";
    public static String LANG_EN = "en";
    public static String LANG_ES_TMDB_ALIAS = "spa";

    public static boolean isPortuguese(String language) {
        return LANG_PT.equalsIgnoreCase(language);
    }

    public static boolean isSpanish(String language) {
        return LANG_ES.equalsIgnoreCase(language);
    }

    public static boolean isEnglish(String language) {
        return LANG_EN.equalsIgnoreCase(language);
    }

    public static boolean isSupportLanguage(String language) {
        return LanguageTools.isEnglish(language) || LanguageTools.isPortuguese(language) || LanguageTools.isSpanish(language);
    }

    public static String spanishAlias(String language) {
        if (LANG_ES_TMDB_ALIAS.equalsIgnoreCase(language)) {
            return LANG_ES;
        }
        return language;
    }

    public static boolean equalLanguage(String lang1, String lang2) {
        if (Strings.isNullOrEmpty((String)lang1) || Strings.isNullOrEmpty((String)lang2)) {
            return false;
        }
        if (lang1.equalsIgnoreCase(lang2)) {
            return true;
        }
        return (LanguageTools.isEnglish(lang1) || LanguageTools.isEnglish(lang2)) && LanguageTools.spanishAlias(lang1).equalsIgnoreCase(LanguageTools.spanishAlias(lang2));
    }

    public static String getLanguage(String languageRegion) {
        List<String> langs = LanguageTools.getLanguageRegionList(languageRegion);
        if (langs.size() > 1) {
            return langs.get(1);
        }
        return "";
    }

    public static String getLanguageRegion(String languageRegion) {
        List<String> langs = LanguageTools.getLanguageRegionList(languageRegion);
        if (langs.size() > 0) {
            return langs.get(0);
        }
        return "";
    }

    public static List<String> getLanguageRegionList(String languageRegion) {
        try {
            return Splitter.on((String)"_").omitEmptyStrings().trimResults().splitToList((CharSequence)languageRegion);
        }
        catch (Exception e) {
            logger.info("Invalid language args:{}", (Object)languageRegion);
            return Lists.newArrayList();
        }
    }

    public static String getOrDefaultLanguage(String language) {
        if (LanguageTools.isSupportLanguage(language)) {
            return language;
        }
        return LANG_EN;
    }

    public static boolean isContainEnglish(String originalLanguage) {
        if (Strings.isNullOrEmpty((String)originalLanguage)) {
            return false;
        }
        try {
            Map languageMap = Splitter.on((String)"|").omitEmptyStrings().trimResults().withKeyValueSeparator(":").split((CharSequence)originalLanguage);
            if (!CollectionUtils.isNullOrEmpty((Map)languageMap) && languageMap.containsKey(LANG_EN)) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("{}:{}", (Object)originalLanguage, (Object)e.getMessage());
        }
        return false;
    }
}

