/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.tools.sys;

import com.valor.mfc.vms.common.tools.sys.KeywordMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public final class PropertyTools
extends PropertyPlaceholderConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyTools.class);
    private static final Properties PROPERTIES = new Properties();
    private int springSystemPropertiesMode = 1;

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        super.setSystemPropertiesMode(systemPropertiesMode);
        this.springSystemPropertiesMode = systemPropertiesMode;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        super.processProperties(beanFactory, props);
        PROPERTIES.clear();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            String valueStr = this.resolvePlaceholder(keyStr, props, this.springSystemPropertiesMode);
            PROPERTIES.put(keyStr, valueStr);
        }
        LOG.info("Loaded {} properties", (Object)PROPERTIES.size());
    }

    public static String getProperty(String key) {
        return StringUtils.trimToNull((String)PROPERTIES.getProperty(key));
    }

    public static String getProperty(String key, String defaultValue) {
        return StringUtils.trimToEmpty((String)PROPERTIES.getProperty(key, defaultValue));
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(key));
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return Boolean.parseBoolean(property.trim());
        }
        return defaultValue;
    }

    public static int getIntProperty(String key, int defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(key));
        return NumberUtils.toInt((String)property, (int)defaultValue);
    }

    public static long getLongProperty(String key, long defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(key));
        return NumberUtils.toLong((String)property, (long)defaultValue);
    }

    public static float getFloatProperty(String key, float defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(key));
        return NumberUtils.toFloat((String)property, (float)defaultValue);
    }

    public static String getReplacedProperty(String newKey, String oldKey, String defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(oldKey));
        if (StringUtils.isBlank((CharSequence)property)) {
            property = PROPERTIES.getProperty(newKey, defaultValue);
        } else {
            LOG.warn("Property '{}' has been deprecated and will be removed; please use '{}' instead", (Object)oldKey, (Object)newKey);
        }
        return property;
    }

    public static boolean getReplacedBooleanProperty(String newKey, String oldKey, boolean defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(oldKey));
        if (StringUtils.isBlank((CharSequence)property)) {
            property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(newKey));
        } else {
            LOG.warn("Property '{}' has been deprecated and will be removed; please use '{}' instead", (Object)oldKey, (Object)newKey);
        }
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return Boolean.parseBoolean(property.trim());
        }
        return defaultValue;
    }

    public static int getReplacedIntProperty(String newKey, String oldKey, int defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(oldKey));
        if (StringUtils.isBlank((CharSequence)property)) {
            property = PROPERTIES.getProperty(newKey);
        } else {
            LOG.warn("Property '{}' has been deprecated and will be removed; please use '{}' instead", (Object)oldKey, (Object)newKey);
        }
        return NumberUtils.toInt((String)PROPERTIES.getProperty(property), (int)defaultValue);
    }

    public static long getReplacedLongProperty(String newKey, String oldKey, long defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(oldKey));
        if (StringUtils.isBlank((CharSequence)property)) {
            property = PROPERTIES.getProperty(newKey);
        } else {
            LOG.warn("Property '{}' has been deprecated and will be removed; please use '{}' instead", (Object)oldKey, (Object)newKey);
        }
        return NumberUtils.toLong((String)PROPERTIES.getProperty(property), (long)defaultValue);
    }

    public static float getReplacedFloatProperty(String newKey, String oldKey, float defaultValue) {
        String property = StringUtils.trimToEmpty((String)PROPERTIES.getProperty(oldKey));
        if (StringUtils.isBlank((CharSequence)property)) {
            property = PROPERTIES.getProperty(newKey);
        } else {
            LOG.warn("Property '{}' has been deprecated and will be removed; please use '{}' instead", (Object)oldKey, (Object)newKey);
        }
        return NumberUtils.toFloat((String)PROPERTIES.getProperty(property), (float)defaultValue);
    }

    public static Set<Map.Entry<Object, Object>> getEntrySet() {
        return new TreeMap<Object, Object>(PROPERTIES).entrySet();
    }

    public static void setProperty(String key, String value) {
        PROPERTIES.setProperty(key, value);
    }

    public static void setProperty(String key, boolean value) {
        PROPERTIES.setProperty(key, Boolean.toString(value));
    }

    public static void setProperty(String key, int value) {
        PROPERTIES.setProperty(key, Integer.toString(value));
    }

    public static void setProperty(String key, long value) {
        PROPERTIES.setProperty(key, Long.toString(value));
    }

    public static KeywordMap getKeywordMap(String prefix, String defaultValue) {
        KeywordMap keywordMap = new KeywordMap();
        String propertyString = PropertyTools.getProperty(prefix, defaultValue);
        if (!StringUtils.isBlank((CharSequence)propertyString)) {
            for (String singleProperty : propertyString.split("[ ,]+")) {
                if ((singleProperty = StringUtils.trimToNull((String)singleProperty)) == null) continue;
                keywordMap.getKeywords().add(singleProperty);
                String values = PropertyTools.getProperty(prefix + "." + singleProperty);
                if (values == null) continue;
                keywordMap.put(singleProperty, values);
            }
        }
        return keywordMap;
    }
}

