/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.tools.type;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.valor.mfc.vms.common.tools.type.StringTools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeTools {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeTools.class);
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static final PeriodFormatter TIME_FORMAT_COLON = DateTimeTools.createPeriodFormatter(":", ":", "");
    private static final PeriodFormatter TIME_FORMAT_TEXT = DateTimeTools.createPeriodFormatter("h", "m", "s");
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String BUILD_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String VMS_TIMEZONE = "GMT-3";
    public static final long SECONDS_OF_DAY = 86400L;
    public static final long MS_OF_DAY = 86400000L;

    private DateTimeTools() {
        throw new UnsupportedOperationException("Utility class");
    }

    private static PeriodFormatter createPeriodFormatter(String hourText, String minuteText, String secondText) {
        return new PeriodFormatterBuilder().appendHours().appendSeparator(hourText).minimumPrintedDigits(2).appendMinutes().appendSeparator(minuteText).appendSecondsWithOptionalMillis().appendSuffix(secondText).toFormatter();
    }

    public static String convertDateToString(Date convertDate) {
        return DateTimeTools.convertDateToString(convertDate, DATE_FORMAT_STRING);
    }

    public static String datetimeToString(Date convertDate) {
        return DateTimeTools.convertDateToString(convertDate, DATE_TIME_FORMAT);
    }

    public static String convertDateToString(Date convertDate, String dateFormat) {
        DateTime dt = new DateTime((Object)convertDate);
        return DateTimeTools.convertDateToString(dt, dateFormat);
    }

    public static String convertDateToString(DateTime convertDate) {
        return DateTimeTools.convertDateToString(convertDate, DATE_FORMAT_STRING);
    }

    public static String convertDateToString(DateTime convertDate, String dateFormat) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)dateFormat);
        return fmt.print((ReadableInstant)convertDate);
    }

    public static long getDuration(Date start, Date end) {
        return DateTimeTools.getDuration(new DateTime((Object)start), new DateTime((Object)end));
    }

    public static long getDuration(Long start, Long end) {
        return DateTimeTools.getDuration(new DateTime((Object)start), new DateTime((Object)end));
    }

    public static long getDuration(DateTime start, DateTime end) {
        if (start.isBefore((ReadableInstant)end)) {
            Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
            return interval.toDurationMillis();
        }
        return -1L;
    }

    public static String formatDurationColon(long milliseconds) {
        return DateTimeTools.formatDuration(milliseconds, TIME_FORMAT_COLON);
    }

    public static String formatDurationText(long milliseconds) {
        return DateTimeTools.formatDuration(milliseconds, TIME_FORMAT_TEXT);
    }

    public static String formatDuration(long milliseconds, PeriodFormatter format) {
        Period period = new Period(milliseconds, PeriodType.time());
        period = period.normalizedStandard();
        return format.print((ReadablePeriod)period);
    }

    public static int processRuntime(String runtime) {
        try {
            int returnValue = Integer.parseInt(runtime);
            return returnValue;
        }
        catch (Exception ignore) {
            int returnValue = -1;
            Pattern hrmnPattern = Pattern.compile("(?i)(\\d+)(\\D*)(\\d*)(.*?)");
            Matcher matcher = hrmnPattern.matcher(runtime);
            if (matcher.find()) {
                String first = matcher.group(1);
                String divide = matcher.group(2);
                String second = matcher.group(3);
                if (StringUtils.isNotBlank((CharSequence)second)) {
                    returnValue = Integer.parseInt(first) * 60 + Integer.parseInt(second);
                    return returnValue;
                }
                if (StringUtils.isBlank((CharSequence)divide)) {
                    returnValue = Integer.parseInt(first);
                    return returnValue;
                }
                if (StringUtils.isBlank((CharSequence)second) && StringUtils.isNotBlank((CharSequence)divide)) {
                    returnValue = divide.toLowerCase().contains("h") ? Integer.parseInt(first) * 60 : Integer.parseInt(first);
                    return returnValue;
                }
            }
            return returnValue;
        }
    }

    public static DateTime parseDate(String stringDate, String datePattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)datePattern);
        return formatter.parseDateTime(stringDate);
    }

    public static long parseDate2Long(String stringDate, String datePattern) {
        DateTime dt = DateTimeTools.parseDate(stringDate, datePattern);
        if (dt != null) {
            return dt.getMillis();
        }
        return 0L;
    }

    public static String distanceToday(int diff) {
        long date = (long)diff * 86400000L;
        Date diffDate = new Date(System.currentTimeMillis() + date);
        return DateTimeTools.getDateStr(diffDate, DATE_FORMAT_STRING);
    }

    public static Date distanceTodayDate(int diff) {
        long date = (long)diff * 86400000L;
        Date diffDate = new Date(System.currentTimeMillis() + date);
        return diffDate;
    }

    public static int distanceTodayInt(int diff) {
        return DateTimeTools.date2IntVal(DateTimeTools.distanceToday(diff));
    }

    public static long distanceTodayMS(int diff) {
        long distanceMS = (long)diff * 1000L * 60L * 60L * 24L;
        return System.currentTimeMillis() + distanceMS;
    }

    public static Date str2Date(String dateStr) {
        try {
            return new SimpleDateFormat(DATE_FORMAT_STRING).parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int date2IntVal(String strDate) {
        if (Strings.isNullOrEmpty((String)strDate)) {
            return 0;
        }
        List splitDate = Lists.newArrayList();
        try {
            splitDate = Splitter.on((String)"-").trimResults().limit(3).splitToList((CharSequence)strDate);
        }
        catch (IllegalArgumentException e) {
            logger.error("{}", (Throwable)e);
            return 0;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        if (splitDate.size() > 0 && ((year = StringTools.toInt((String)splitDate.get(0))) < 0 || year > 9999)) {
            year = 0;
        }
        if (splitDate.size() > 1 && ((month = StringTools.toInt((String)splitDate.get(1))) < 0 || month > 12)) {
            month = 0;
        }
        if (splitDate.size() > 2 && ((day = StringTools.toInt((String)splitDate.get(2))) < 0 || day > 31)) {
            day = 0;
        }
        return year * 10000 + month * 100 + day;
    }

    public static String currentDateStr(String dateFormat) {
        return DateTimeTools.getDateStr(new Date(), dateFormat);
    }

    public static String currentDateStr2() {
        return DateTimeTools.currentDateStr(DATE_FORMAT_STRING);
    }

    public static String getDateStr(Date date, String format) {
        return DateTimeTools.getDateStr(date, format, VMS_TIMEZONE);
    }

    public static String getDateStr(Date date, String format, String timeZoneStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (!Strings.isNullOrEmpty((String)timeZoneStr)) {
            sdf.setTimeZone(TimeZone.getTimeZone(timeZoneStr));
        }
        return sdf.format(date).toString();
    }

    private static String distanceToday(int type, int distanceMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(type, distanceMonth);
        Date dBefore = calendar.getTime();
        return DateTimeTools.getDateStr(dBefore, DATE_FORMAT_STRING);
    }

    public static String distanceTodayByMonth(int distance) {
        return DateTimeTools.distanceToday(2, distance);
    }

    public static int distanceTodayByMonthInt(int distance) {
        return DateTimeTools.date2IntVal(DateTimeTools.distanceTodayByMonth(distance));
    }

    public static String getDateAMonthAgo() {
        return DateTimeTools.distanceTodayByMonth(-1);
    }

    public static String distanceTodayByDay(int distance) {
        return DateTimeTools.distanceToday(6, distance);
    }

    public static String millis2DateStr(long time) {
        Date date = new Date(time);
        return DateTimeTools.getDateStr(date, "yyyy-MM-dd HH:mm:ss.S");
    }

    public static int currentDateInt() {
        return DateTimeTools.date2IntVal(DateTimeTools.currentDateStr2());
    }

    public static int dateAMonthAgoInt() {
        return DateTimeTools.date2IntVal(DateTimeTools.getDateAMonthAgo());
    }

    public static Date maxDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.getTime() > d2.getTime()) {
            return d1;
        }
        return d2;
    }

    public static boolean outOfTimeLimit(long beforeTs, long limitTS) {
        if (beforeTs == 0L || limitTS == 0L) {
            return false;
        }
        return System.currentTimeMillis() - beforeTs < limitTS;
    }

    public static long getSecondsOfDays(long days) {
        return days * 86400L;
    }

    public static long dateCeil(long ms) {
        long part = ms % 86400000L;
        return ms - part + 86400000L;
    }

    public static long dateCeil(long nowMS, int secondUnit) {
        int ms = secondUnit * 1000;
        long part = nowMS % (long)ms;
        return nowMS - part + (long)ms;
    }

    public static long dateFloor(long nowMS, int secondUnit) {
        return nowMS - nowMS % (long)(secondUnit * 1000);
    }

    public static long dateFloor(int secondUnit) {
        long now = System.currentTimeMillis();
        return DateTimeTools.dateFloor(now, secondUnit);
    }

    public static int getMaxDayByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return calendar.getActualMaximum(5);
    }

    public static String fmtDate(String dateStr, boolean ceil) {
        if (Strings.isNullOrEmpty((String)dateStr)) {
            return "";
        }
        List splitDate = Lists.newArrayList();
        try {
            splitDate = Splitter.on((String)"-").trimResults().limit(3).splitToList((CharSequence)dateStr);
        }
        catch (IllegalArgumentException e) {
            logger.error("{}", (Throwable)e);
            return "";
        }
        int year = 0;
        int month = 0;
        int day = 0;
        if (splitDate.size() > 0 && ((year = StringTools.toInt((String)splitDate.get(0))) < 0 || year > 9999)) {
            year = 0;
        }
        if (splitDate.size() > 1 && ((month = StringTools.toInt((String)splitDate.get(1))) < 0 || month > 12)) {
            month = 0;
        }
        if (splitDate.size() > 2 && ((day = StringTools.toInt((String)splitDate.get(2))) < 0 || day > 31)) {
            day = 0;
        }
        if (ceil) {
            year = year == 0 ? 2037 : year;
            month = month == 0 ? 12 : month;
            day = day == 0 ? DateTimeTools.getMaxDayByYearMonth(year, month) : day;
        } else {
            year = year == 0 ? 1970 : year;
            month = month == 0 ? 1 : month;
            day = day == 0 ? 1 : day;
        }
        return Joiner.on((String)"-").join((Object)year, (Object)month, new Object[]{day});
    }

    public static Date getDateFromLocaleStr(String dateStr, String format, Locale locale) {
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)format).withLocale(locale);
            DateTime datetime = fmt.parseDateTime(dateStr);
            return datetime.toDate();
        }
        catch (Exception e) {
            logger.error("fmt date [{}] exception:{}", (Object)dateStr, (Object)e.getMessage());
            return null;
        }
    }
}

