/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.web.request;

import com.google.common.base.Strings;
import com.valor.mfc.vms.api.model.common.EResultItem;
import com.valor.mfc.vms.api.model.tools.UserPropTools;
import com.valor.mfc.vms.api.model.user.EUserProps;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import com.valor.mfc.vms.common.tools.meta.LanguageTools;
import com.valor.mfc.vms.common.web.request.AbstractRequestArgs;
import com.valor.mfc.vms.common.web.request.IRequestBaseArgs;
import com.valor.mfc.vms.common.web.tools.RegionTools;
import com.valor.mfc.vms.common.web.tools.ResultItemTools;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BaseRequestArgs
extends AbstractRequestArgs
implements IRequestBaseArgs {
    private int debug = 0;
    private long appVer = -1L;
    private String actKey = "";
    private String sessionKey = "";
    private String token = "";
    private String did = "";
    private long uid = -1L;
    private long accountId = -1L;
    private int accountType = -1;
    private String lang = "en_US";
    private String region = "us";
    private String manualRegion;
    private int linked = 0;
    private String appendResult = "";
    private String language = "en";
    private String excludeResult = "";
    private String clientIp = "";
    private String clientRegion = "";
    private long userProps = 0L;
    private String endUserIp = "";
    private String endUserRegion = "";
    private String deviceId = "";
    private String clientSession;
    private int clientTypeNeedVerifySession = 0;
    private String appId;
    private String releaseId;
    private String client;
    private String st;
    private Long vendorId;
    private String model;
    private String brand;
    private String cpuId;
    private String launcherAppId;
    private String protocol;
    private String channelId;
    private String channelDeviceType;
    private String distirbutorId;
    private EnumSet<EResultItem> includeSet = null;
    private EnumSet<EResultItem> excludeSet = null;
    String vendor;

    @Override
    public boolean isArgsValid() {
        this.checkLanguage();
        return super.isArgsValid();
    }

    public boolean isAppReq() {
        return this.clientTypeNeedVerifySession == 0;
    }

    public int getClientTypeNeedVerifySession() {
        return this.clientTypeNeedVerifySession;
    }

    public void setClientTypeNeedVerifySession(int clientTypeNeedVerifySession) {
        this.clientTypeNeedVerifySession = clientTypeNeedVerifySession;
    }

    public String getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(String clientSession) {
        this.clientSession = clientSession;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getLanguageRegion() {
        return LanguageTools.getLanguageRegion(this.lang);
    }

    public boolean checkLanguage() {
        List<String> list = LanguageTools.getLanguageRegionList(this.lang);
        if (list.size() < 2) {
            this.argsValid = false;
            this.setVerifyMsg("language", "Invalid VALUE.");
            return false;
        }
        return true;
    }

    public EnumSet<EResultItem> getAppendResultAsSet() {
        if (this.includeSet == null) {
            this.includeSet = ResultItemTools.parseResult(this.appendResult);
        }
        return this.includeSet;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    @Override
    public long getAppVer() {
        return this.appVer;
    }

    public void setAppVer(long appVer) {
        this.appVer = appVer;
    }

    @Override
    public String getActKey() {
        return this.actKey;
    }

    public void setActKey(String actKey) {
        this.actKey = actKey;
    }

    public String getSt() {
        return this.st;
    }

    public void setSt(String st) {
        this.st = st;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    @Override
    public String getLanguage() {
        if (!Strings.isNullOrEmpty((String)this.language)) {
            return LanguageTools.getOrDefaultLanguage(this.language);
        }
        return LanguageTools.getLanguage(this.lang);
    }

    @Override
    public String getAppendResult() {
        return this.appendResult;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String getRegion() {
        return this.region.toLowerCase();
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getManualRegion() {
        return this.manualRegion;
    }

    public void setManualRegion(String manualRegion) {
        this.manualRegion = manualRegion;
    }

    @Override
    public int getLinked() {
        return this.linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public void setAppendResult(String appendResult) {
        this.appendResult = appendResult;
    }

    public void setArgsFromParameter(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            this.deviceId = this.did;
            this.did = HttpTools.getAttr(httpRequest, "_did", this.deviceId);
            if (this.uid == -1L) {
                this.uid = HttpTools.getLongAttr(httpRequest, "_uid", -1L);
            }
            if (this.accountId == -1L) {
                this.accountId = HttpTools.getLongAttr(httpRequest, "_accountId", -1L);
            }
            if (this.accountType == -1) {
                this.accountType = HttpTools.getIntAttr(httpRequest, "accountType", -1);
            }
            if (Strings.isNullOrEmpty((String)this.token)) {
                this.token = HttpTools.getAttr(httpRequest, "_token", "");
            }
            this.userProps = HttpTools.getLongAttr(httpRequest, "_uprop", 0L);
            this.clientIp = HttpTools.getRemoteHost(httpRequest);
            this.clientRegion = HttpTools.getClientRegion(httpRequest);
            if (this.clientSession == null) {
                this.clientSession = HttpTools.getAttr(httpRequest, "clientSession", "");
            }
        }
    }

    public String getRegion2() {
        return RegionTools.getRegion2(this.region);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getExcludeResult() {
        return this.excludeResult;
    }

    public void setExcludeResult(String excludeResult) {
        this.excludeResult = excludeResult;
    }

    public EnumSet<EResultItem> getExcludeResultAsSet() {
        if (this.excludeSet == null) {
            this.excludeSet = ResultItemTools.parseResult(this.excludeResult);
        }
        return this.excludeSet;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public long getUserProps() {
        return this.userProps;
    }

    public void setUserProps(long userProps) {
        this.userProps = userProps;
    }

    public boolean isUserPropSet(EUserProps eup) {
        return UserPropTools.isPropertySet((long)this.userProps, (EUserProps)eup);
    }

    public boolean isUserLocationIllegal() {
        return this.isUserPropSet(EUserProps.LOCATION_ILLEGAL);
    }

    public String getClientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public String getLang() {
        return this.lang;
    }

    public EnumSet<EResultItem> getIncludeSet() {
        return this.includeSet;
    }

    public void setIncludeSet(EnumSet<EResultItem> includeSet) {
        this.includeSet = includeSet;
    }

    public EnumSet<EResultItem> getExcludeSet() {
        return this.excludeSet;
    }

    public void setExcludeSet(EnumSet<EResultItem> excludeSet) {
        this.excludeSet = excludeSet;
    }

    public String getEndUserIp() {
        return this.endUserIp;
    }

    public void setEndUserIp(String endUserIp) {
        this.endUserIp = endUserIp;
    }

    public String getEndUserRegion() {
        return this.endUserRegion;
    }

    public void setEndUserRegion(String endUserRegion) {
        this.endUserRegion = endUserRegion;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCpuId() {
        return this.cpuId;
    }

    public void setCpuId(String cpuId) {
        this.cpuId = cpuId;
    }

    public String getLauncherAppId() {
        return this.launcherAppId;
    }

    public void setLauncherAppId(String launcherAppId) {
        this.launcherAppId = launcherAppId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelDeviceType() {
        return this.channelDeviceType;
    }

    public void setChannelDeviceType(String channelDeviceType) {
        this.channelDeviceType = channelDeviceType;
    }

    public String getDistirbutorId() {
        return this.distirbutorId;
    }

    public void setDistirbutorId(String distirbutorId) {
        this.distirbutorId = distirbutorId;
    }
}

