package com.valor.mfc.vms.meta.model.database.ddo.linked;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/10/18.
 */
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Entity
@Table(name = "linked_cloud",indexes = {
        @Index(name = "index_linked_cloud_meta",columnList = "cid,meta_id"),
        @Index(name = "index_linked_cloud_video",columnList = "cid,video_id"),
        @Index(name = "index_linked_cloud_cid",columnList = "cid"),
        @Index(name = "index_linked_cloud_video",columnList = "cid,video_id,season")

})
public class LinkedCloudDdo extends AbstractLMI {
    @Id
    @Column(name="cid")
    public Long cid=-1L;

    @Id
    @Column(name="res_id",length = 128)
    public String resId;

    @Column(name="meta_id",length = 64)
    private String metaId;

    @Column(name = "video_id")
    private long videoId = -1;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType = EVideoType.UNKNOWN;

    @Column(name = "season")
    private int season;

    @Column(name = "episode")
    private int episode;

    @Column(name = "quality",length = 64)
    private String quality;

    @Column(name = "format",length = 64)
    private String format;

    @Column(name = "extra",length = 1024)
    private String extra;

    @Column(name = "linked_time")
    private long LinkedTime = 0;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public long getVideoId() {
        return videoId;
    }

    public void setVideoId(long videoId) {
        this.videoId = videoId;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public long getLinkedTime() {
        return LinkedTime;
    }

    public void setLinkedTime(long linkedTime) {
        LinkedTime = linkedTime;
    }
}
