package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractSimilor extends AbstractId {
    @Id
    @Column(name="similor_id")
    public long similorId;

    public long getSimilorId() {
        return similorId;
    }

    public void setSimilorId(long similorId) {
        this.similorId = similorId;
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,similorId);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractSimilor that = (AbstractSimilor) o;

        return Objects.equal(this.similorId, that.similorId) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(similorId, id);
    }
}
