package com.valor.mfc.vms.meta.model.database.ddo.person;

import com.google.common.base.Objects;

import com.valor.mfc.vms.api.model.constant.response.EFilmographyJob;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/12/14.
 */
@Entity
@Table(name = "vms_person_filmography2",
        indexes = {@Index(name = "idx_vms_person_filmography2_person_id",columnList = "person_id")}
)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)

public class PersonFilmography2 extends AbstractPersonFilmography {
    @Id
    @Column(name = "job")
    public EFilmographyJob job = EFilmographyJob.UNKNOWN;

    public EFilmographyJob getJob() {
        return job;
    }

    public void setJob(EFilmographyJob job) {
        this.job = job;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonFilmography2 that = (PersonFilmography2) o;

        return Objects.equal(this.job, that.job) &&
                Objects.equal(this.personId, that.personId) &&
                Objects.equal(this.mediaId, that.mediaId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(job, personId, mediaId);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(personId,mediaId,job);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        }

        PersonFilmography2 that = (PersonFilmography2) o;
        return Objects.equal(this.mediaType,that.mediaType);
    }
}
