package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import common.base.tools.type.CollectionUtils;
import com.valor.mfc.vms.api.model.constant.EArtworkType;
import com.valor.mfc.vms.api.model.constant.EMetaSource;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.database.model.IComparable;
import com.valor.mfc.vms.meta.model.database.constants.EMetaModifyProperty;
import com.valor.mfc.vms.meta.model.database.constants.EMetaProperty;
import com.valor.mfc.vms.meta.model.database.constants.MMDataFlag;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.mfc.vms.meta.model.database.tools.BitTools;
import com.valor.mfc.vms.meta.model.database.tools.media.Meta4QueryWrapper;
import com.valor.mfc.vms.meta.model.database.tools.media.MetaModifyFlagWrapper;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/**
 * Created by Frank.Huang on 2016/6/22.
 */
public class MetaMergeDto {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(MetaMergeDto.class);

    protected String field = "";
    protected Set<Object> toBeDelSet  = Sets.newHashSet();
    protected Meta4QueryWrapper meta4QueryWrapper     = null;
    protected MetaModifyFlagWrapper modifyFlagWrapper = new MetaModifyFlagWrapper();

    protected Map<String,Integer> changedMap = Maps.newHashMap();
    protected Map<String,Integer> deleteMap  = Maps.newHashMap();


    public MetaMergeDto(String field) {
        this.field = field;
        meta4QueryWrapper     = new Meta4QueryWrapper(null,field);
    }

    public void setMeta4Query(Meta4Query meta4Query){
        meta4QueryWrapper = new Meta4QueryWrapper(meta4Query,field);
    }

    public Meta4QueryWrapper getMeta4QueryWrapper() {
        return meta4QueryWrapper;
    }

    public Set<Object> getToBeDelSet() {
        return toBeDelSet;
    }
    public void setToBeDelSet(Set<Object> toBeDelSet) {
        this.toBeDelSet = toBeDelSet;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Set mapValueAsSet(Map map){
        return Sets.newHashSet(map.values());
    }


    public void addIfChange(Map valueMap, IComparable v,IChangedMerge change) {
        IComparable old = (IComparable) valueMap.get(v.valueKey());
        if (old == null){
            valueMap.put(v.valueKey(), v);
            addChanged(v);
        }else {
            if (change != null){
                change.onMerge(old,v);
            }

            if (old.valueEquals(v)){
                valueMap.remove(old.valueKey());
            }else {
                valueMap.replace(v.valueKey(), v);
                addChanged(v);
            }
        }
    }

    public void addAllIfChange(Map valueMap, Collection valueList) {
        addAllIfChange(valueMap,valueList,null);
    }

    public void addAllIfChange(Map valueMap, Collection valueList,IChangedMerge change) {
        if (CollectionUtils.isNullOrEmpty(valueList)){
            return;
        }

        valueList.forEach(e->{
            addIfChange(valueMap, (IComparable) e,change);
        });
    }

    public void setAll(Map valueMap, Collection values) {
        if (CollectionUtils.isNullOrEmpty(values)){
            return;
        }

        values.forEach(e->{
            IComparable v = (IComparable) e;
            v.setToBeDel(MMDataFlag.TO_BE_DEL);
            valueMap.put(v.valueKey(),v);
        });
    }


    public void setToBeDel(Map valeMap){
        Set<Object> tbdList = Sets.newHashSet();
        if (!CollectionUtils.isNullOrEmpty(valeMap)){
            for (Object e : valeMap.values()){
                if (e instanceof AbstractLMI){
                    if (((AbstractLMI) e).getToBeDel() == MMDataFlag.TO_BE_DEL
                        && ((AbstractLMI) e).getDataVersion()!= MMDataFlag.DETA_MM_VERSION){
                        tbdList.add(e);
                        addDelete(e);
                    }
                }
            }

            if (!CollectionUtils.isNullOrEmpty(tbdList)){
                tbdList.forEach(e->{
                    valeMap.remove(((AbstractLMI) e).valueKey());
                });

                toBeDelSet.addAll(tbdList);
            }
        }
    }

    public void updateFlag(AbstractMedia v){
        if (v != null){
            v.setComplete(meta4QueryWrapper.getMetaFlag());
            v.setManual(modifyFlagWrapper.getFlags());
        }
    }


    public int replaceFlag(int t, int s, int flag) {
        int v = t;
        if (BitTools.isSet(s,flag)){
            v = BitTools.setBit(t, flag);
        }else {
            v = BitTools.clsBit(t, flag);
        }
        return v;
    }

    public void updateImageFlag(AbstractMedia v) {
        if (v == null) {
            return;
        }

        int propFlag = v.getComplete();
        propFlag = replaceFlag(propFlag, meta4QueryWrapper.getMetaFlag(), EMetaProperty.META_ARTWORK_POSTTER.getValue());
        propFlag = replaceFlag(propFlag, meta4QueryWrapper.getMetaFlag(), EMetaProperty.META_ARTWORK_BACKDROP.getValue());
        v.setComplete(propFlag);

        int manualFlag = v.getManual();
        manualFlag = replaceFlag(manualFlag, modifyFlagWrapper.getFlags(), EMetaModifyProperty.META_MODFIY_POSTTER.getValue());
        manualFlag = replaceFlag(manualFlag, modifyFlagWrapper.getFlags(), EMetaModifyProperty.META_MODIFY_BACKDROP.getValue());
        v.setManual(manualFlag);

        addChanged(v);
    }

    public Meta4Query getMeta4Query(){
        return meta4QueryWrapper.getMeta4Query();
    }

    public void updateArtworkModifyFlag(Set set,MetaModifyFlagWrapper flagWrapper){
        if (CollectionUtils.isNullOrEmpty(set)){
            return;
        }

        for (Object e :set){
            AbstractArtwork v = (AbstractArtwork) e;
            if (v.getSource() == EMetaSource.VXMFC && v.getMaster() == 1){
                if (v.getArtworkType()== EArtworkType.POSTER){
                    flagWrapper.setFlag(EMetaModifyProperty.META_MODFIY_POSTTER);
                }

                if (v.getArtworkType()==EArtworkType.BACKDROP){
                    flagWrapper.setFlag(EMetaModifyProperty.META_MODIFY_BACKDROP);
                }
            }
        }

        for (Object e :set){
            AbstractArtwork v = (AbstractArtwork) e;
            if (v.getSource()!= EMetaSource.VXMFC){
                if (v.getArtworkType()==EArtworkType.POSTER && v.getMaster() == 1 && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER)){
                    v.setMaster(0);
                }

                if (v.getArtworkType()==EArtworkType.BACKDROP && v.getMaster() == 1 && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP)){
                    v.setMaster(0);
                }
            }
        }
    }

    public void addDelete(Object o){
        if (o == null){
            return;
        }

        String name = o.getClass().getSimpleName();
        int v = deleteMap.getOrDefault(name,0);
        deleteMap.put(name,v+1);
    }

    public void addChanged(Object o){
        if (o == null){
            return;
        }

        String name = o.getClass().getSimpleName();
        int v = changedMap.getOrDefault(name,0);
        changedMap.put(name,v+1);
    }

    public String dumpSyncStat(AbstractMedia media){
        if (media!=null){
            return dumpSyncStat(media.getId(),media.getImdbId(),media.getType());
        }else {
            return dumpSyncStat(0,"x",EVideoType.UNKNOWN);
        }
    }


    public String dumpSyncStat(long metaId, String metaId2, EVideoType type){
        StringBuilder sb = new StringBuilder();
        sb.append("[SYNC][STAT]");
        sb.append("[")
          .append(metaId).append("-")
          .append(metaId2).append("-")
          .append(type).append("-")
          .append(field)
          .append("]");


        if (!changedMap.isEmpty()){
            sb.append(" Changed:[").append(Joiner.on(",").withKeyValueSeparator(":").join(changedMap)).append("]");
        }
        if (!deleteMap.isEmpty()){
            sb.append(" Delete:[").append(Joiner.on(",").withKeyValueSeparator(":").join(deleteMap)).append("]");
        }

        return sb.toString();
    }

    public MetaModifyFlagWrapper getModifyFlagWrapper() {
        return modifyFlagWrapper;
    }


    public Set<String> getChangedTables(){
        Set<String> changedSet = Sets.newHashSet();
        changedSet.addAll(changedMap.keySet());
        changedSet.addAll(deleteMap.keySet());
        return changedSet;
    }
}
