package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.collect.Sets;

import com.valor.mfc.vms.meta.model.database.ddo.person.AbstractPersonFilmography;
import com.valor.mfc.vms.meta.model.database.ddo.person.AbstractPersonLocale;
import com.valor.mfc.vms.meta.model.database.ddo.person.Person;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonAward;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonKnowFor;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonLocale;

import java.util.Objects;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
public class PersonDto {
    private Person person;
    private PersonLocale locale;
    private AbstractPersonLocale mlLocale;
    private Set<PersonKnowFor> knowFors          = Sets.newHashSet();
    private Set<PersonAward> awards              = Sets.newHashSet();
    private Set<AbstractPersonFilmography> filmographies = Sets.newHashSet();


    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PersonLocale getLocale() {
        return locale;
    }

    public void setLocale(PersonLocale locale) {
        this.locale = locale;
    }

    public Set<PersonKnowFor> getKnowFors() {
        return knowFors;
    }

    public void setKnowFors(Set<PersonKnowFor> knowFors) {
        this.knowFors = knowFors;
    }

    public boolean isValid(){
        if (Objects.isNull(person)){
            return false;
        }

        return true;
    }

    public Set<PersonAward> getAwards() {
        return awards;
    }

    public void setAwards(Set<PersonAward> awards) {
        this.awards = awards;
    }

    public Set<AbstractPersonFilmography> getFilmographies() {
        return filmographies;
    }

    public void setFilmographies(Set<AbstractPersonFilmography> filmographies) {
        this.filmographies = filmographies;
    }

    public AbstractPersonLocale getMlLocale() {
        return mlLocale;
    }

    public void setMlLocale(AbstractPersonLocale mlLocale) {
        this.mlLocale = mlLocale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonDto that = (PersonDto) o;

        return com.google.common.base.Objects.equal(this.person, that.person);
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode(person);
    }
}
