package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.collect.Maps;

import com.valor.mfc.vms.meta.model.database.ddo.person.AbstractPersonFilmography;
import com.valor.mfc.vms.meta.model.database.ddo.person.AbstractPersonLocale;
import com.valor.mfc.vms.meta.model.database.ddo.person.Person;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonAward;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonAwardES;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonAwardPT;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonKnowFor;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonLocale;
import com.valor.mfc.vms.meta.model.service.SyncFieldTools;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/6/22.
 */
public class PersonDto4Merge extends MetaMergeDto {
    private Person person;
    private PersonLocale locale;
    private AbstractPersonLocale mlLocales;

    private Map<String,PersonKnowFor> knowFors          = Maps.newHashMap();
    private Map<String,PersonAward> awards              =  Maps.newHashMap();
    private Map<String,AbstractPersonFilmography> filmographies = Maps.newHashMap();
    private Map<String,PersonAwardES> esAwards  =  Maps.newHashMap();
    private Map<String,PersonAwardPT> ptAwards  =  Maps.newHashMap();


    public PersonDto4Merge(PersonDto personDto,String field) {
        super(field);
        if (personDto!=null){
            this.person = personDto.getPerson();
            this.locale = personDto.getLocale();
            if (SyncFieldTools.isMeta(field)){
                setKnowFors(personDto.getKnowFors());
                setAwards(personDto.getAwards());
                setFilmographies(personDto.getFilmographies());
            }
        }
    }

    public PersonDto4Merge(String field) {
        super(field);
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PersonLocale getLocale() {
        return locale;
    }

    public void setLocale(PersonLocale locale) {
        this.locale = locale;
    }

    public Set<PersonKnowFor> getKnowFors() {
        return mapValueAsSet(knowFors);
    }

    public void setKnowFors(Set<PersonKnowFor> values) {
        setAll(knowFors,values);
    }



    public void addKnowFors(Set<PersonKnowFor> values) {
        addAllIfChange(knowFors, values);
    }

    public boolean isValid(){
        if (Objects.isNull(person)){
            return false;
        }

        return true;
    }

    public Set<PersonAward> getAwards() {
        return mapValueAsSet(awards);
    }

    public void setAwards(Set<PersonAward> awards) {
        setAll(this.awards,awards);
    }

    public void addAwards(Set<PersonAward> awards) {
        addAllIfChange(this.awards,awards);
    }

    public Set<AbstractPersonFilmography> getFilmographies() {
        return mapValueAsSet(filmographies);
    }

    public void setFilmographies(Set<AbstractPersonFilmography> filmographies) {
        setAll(this.filmographies, filmographies);
    }

    public void addFilmographies(Set<AbstractPersonFilmography> filmographies) {
        addAllIfChange(this.filmographies,filmographies);
    }

    public AbstractPersonLocale getMlLocales() {
        return mlLocales;
    }

    public void setMlLocales(AbstractPersonLocale mlLocales) {
        this.mlLocales = mlLocales;
    }


    public Set<PersonAwardES> getEsAward(){
        return mapValueAsSet(esAwards);
    }

    public void setEsAwards(Set<PersonAwardES> esAwards) {
        setAll(this.esAwards,esAwards);
    }

    public void addEsAwards(Set<PersonAwardES> esAwards) {
        addAllIfChange(this.esAwards,esAwards);
    }


    public Set<PersonAwardPT> getPtAward(){
        return mapValueAsSet(ptAwards);
    }

    public void setPtAwards(Set<PersonAwardPT> values) {
        setAll(this.ptAwards,values);
    }

    public void addPtAwards(Set<PersonAwardPT> values) {
        addAllIfChange(this.ptAwards,values);
    }

    @Override
    public Set<Object> getToBeDelSet() {
        setToBeDel(knowFors);
        setToBeDel(awards);
        setToBeDel(filmographies);
        setToBeDel(esAwards);
        setToBeDel(ptAwards);
        return super.getToBeDelSet();
    }
}
