package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import com.valor.mfc.vms.meta.model.database.ddo.media.tv.Season;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.Series;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.SeriesLocale;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesAttrbute;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesAward;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCastCrew;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCountry;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesGenre;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesParentsGuide;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesReleaseInfo;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesSimilar;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesSynopsis;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesTitleAKA;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesTrailer;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesUserReview;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.Video;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoAttribute;

import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
public class TVMetaDto4Merge extends MetaMergeDto {
    private Series series;
    private SeriesLocale seriesLocale;
    private Map<String, Season>  seasons       = Maps.newHashMap();
    private Map<String, Video>   episodes      = Maps.newHashMap();

    private Map<String, TVSeriesTrailer>      trailers      = Maps.newHashMap();
    private Map<String, TVSeriesArtwork>      artworks      = Maps.newHashMap();
    private Map<String, TVSeriesSynopsis>     synopsises    = Maps.newHashMap();
    private Map<String, TVSeriesUserReview>   userReviews   = Maps.newHashMap();
    private Map<String, TVSeriesGenre>         genres       = Maps.newHashMap();
    private Map<String, TVSeriesCountry>       countries    = Maps.newHashMap();
    private Map<String, TVSeriesCertification> certs        = Maps.newHashMap();
    private Map<String, TVSeriesSimilar>       similars     = Maps.newHashMap();
    private Map<String, TVSeriesReleaseInfo>   releaseInfos = Maps.newHashMap();
    private Map<String, TVSeriesCastCrew>      casts        = Maps.newHashMap();
    private Map<String, TVSeriesTitleAKA>      titleAkas    = Maps.newHashMap();
    private Map<String, TVSeriesAward>         awards       = Maps.newHashMap();
    private Map<String, PersonDto>             persons      = Maps.newHashMap();
    private Map<String, TVSeriesParentsGuide>  parentsGuides = Maps.newHashMap();
    private Map<String, TVSeriesAttrbute>      attributes    = Maps.newHashMap();


    public TVMetaDto4Merge(String field) {
        super(field);
    }

    public boolean isInvaild(){
        return (series == null);
    }

    public Series getSeries() {
        return series;
    }

    public void setSeries(Series series,boolean isUpdate) {

        //如果原来已经metaid，保持不变
        if (series != null && this.series != null && !Strings.isNullOrEmpty(this.series.getMetaId())){
            series.setMetaId(this.getSeries().getMetaId());
        }

        this.series = series;
        if (isUpdate){
            meta4QueryWrapper.updateMetaFlag(series);
        }
        addChanged(this.series);
    }

    public SeriesLocale getSeriesLocale() {
        return seriesLocale;
    }

    public void setSeriesLocale(SeriesLocale seriesLocale) {
        this.seriesLocale = seriesLocale;
        addChanged(this.seriesLocale);
    }

    public Set<Season> getSeasons() {
        return mapValueAsSet(seasons);
    }

    public void setSeasons(Set<Season> seasons) {
        setAll(this.seasons,seasons);
    }

    public void addSeasons(Set<Season> seasons) {
        addAllIfChange(this.seasons, seasons);
        if (series!=null && seasons != null){
            series.setSeasonNo(seasons.size());
        }
    }



    public Set<Video> getEpisodes() {
        return mapValueAsSet(episodes);
    }

    public void setEpisodes(Set<Video> episodes) {
        setAll(this.episodes,episodes);
    }

    public void addEpisodes(Set<Video> episodes) {
        addAllIfChange(this.episodes,episodes);
        if (series!=null && episodes != null){
            series.setEpisodeNo(episodes.size());
        }
    }

    public Set<TVSeriesTrailer> getTrailers() {
        return mapValueAsSet(trailers);
    }

    public void setTrailers(Set<TVSeriesTrailer> trailers) {
        setAll(this.trailers,trailers);

    }

    public void addTrailers(Set<TVSeriesTrailer> trailers) {
        addAllIfChange(this.trailers,trailers);
    }




    public Set<TVSeriesArtwork> getArtworks() {
        return mapValueAsSet(artworks);
    }

    public void setArtworks(Set<TVSeriesArtwork> artworks) {
        updateArtworkModifyFlag(artworks, modifyFlagWrapper);
        setAll(this.artworks,artworks);

    }

    public void addArtworks(Set<TVSeriesArtwork> artworks) {
        updateArtworkModifyFlag(artworks, modifyFlagWrapper);
        addAllIfChange(this.artworks, artworks, new ArtworkChangedMerge());
        meta4QueryWrapper.updateArtworkFlag(artworks,modifyFlagWrapper);
    }



    public Set<TVSeriesSynopsis> getSynopsises() {
        return mapValueAsSet(this.synopsises);
    }

    public void setSynopsises(Set<TVSeriesSynopsis> synopsises) {
        setAll(this.synopsises,synopsises);
    }

    public void addSynopsises(Set<TVSeriesSynopsis> synopsises) {
        addAllIfChange(this.synopsises,synopsises);
    }


    public Set<TVSeriesUserReview> getUserReviews() {
        return mapValueAsSet(this.userReviews);
    }

    public void setUserReviews(Set<TVSeriesUserReview> userReviews) {
        setAll(this.userReviews,userReviews);
    }

    public void addUserReviews(Set<TVSeriesUserReview> userReviews) {
        addAllIfChange(this.userReviews,userReviews);
    }

    public Set<TVSeriesGenre> getGenres() {
        return mapValueAsSet(genres);
    }

    public void setGenres(Set<TVSeriesGenre> genres) {
        setAll(this.genres,genres);
    }

    public void addGenres(Set<TVSeriesGenre> genres) {
        addAllIfChange(this.genres,genres);
        meta4QueryWrapper.updateGenreFlag(genres);
    }

    public Set<TVSeriesCountry> getCountries() {
        return mapValueAsSet(countries);
    }


    public void setCountries(Set<TVSeriesCountry> countries) {
        setAll(this.countries,countries);
    }

    public void addCountries(Set<TVSeriesCountry> countries) {
        addAllIfChange(this.countries,countries);
        meta4QueryWrapper.updateRegionFlag(countries);
    }

    public Set<TVSeriesCertification> getCerts() {
        return mapValueAsSet(certs);
    }

    public void setCerts(Set<TVSeriesCertification> certs) {
        setAll(this.certs,certs);
    }

    public void addCerts(Set<TVSeriesCertification> certs) {
        addAllIfChange(this.certs,certs);
        meta4QueryWrapper.updateCertFlag(certs);
    }

    public Set<TVSeriesSimilar> getSimilars() {
        return mapValueAsSet(similars);
    }

    public void setSimilars(Set<TVSeriesSimilar> similars) {
        setAll(this.certs, similars);
    }

    public void addSimilars(Set<TVSeriesSimilar> similars) {
        addAllIfChange(this.certs, similars);
    }

    public Set<TVSeriesReleaseInfo> getReleaseInfos() {
        return Sets.newHashSet(releaseInfos.values());
    }

    public void setReleaseInfos(Set<TVSeriesReleaseInfo> releaseInfos) {
        setAll(this.releaseInfos, releaseInfos);
    }

    public void addReleaseInfos(Set<TVSeriesReleaseInfo> releaseInfos) {
        addAllIfChange(this.releaseInfos, releaseInfos);
    }

    public Set<TVSeriesCastCrew> getCasts() {
        return Sets.newHashSet(casts.values());
    }

    public void setCasts(Set<TVSeriesCastCrew> casts) {
        setAll(this.casts, casts);
    }

    public void addCasts(Set<TVSeriesCastCrew> casts) {
        addAllIfChange(this.casts, casts);
    }



    public Set<PersonDto> getPersons() {
        return Sets.newHashSet(persons.values());
    }

    public void setPersons(Set<PersonDto> persons) {

    }

    public Set<TVSeriesTitleAKA> getTitleAkas() {
        return Sets.newHashSet(titleAkas.values());
    }

    public void setTitleAkas(Set<TVSeriesTitleAKA> titleAkas) {
        setAll(this.titleAkas, titleAkas);
    }

    public void addTitleAkas(Set<TVSeriesTitleAKA> titleAkas) {
        addAllIfChange(this.titleAkas, titleAkas);
    }

    public Set<TVSeriesAward> getAwards() {
        return Sets.newHashSet(awards.values());
    }

    public void setAwards(Set<TVSeriesAward> awards) {
        setAll(this.awards, awards);
    }

    public void addAwards(Set<TVSeriesAward> awards) {
        addAllIfChange(this.awards, awards);
    }

    public Set<TVSeriesParentsGuide> getParentsGuides() {
        return mapValueAsSet(this.parentsGuides);
    }

    public void setParentsGuides(Set<TVSeriesParentsGuide> valueSet) {
        setAll(this.parentsGuides, valueSet);
    }

    public void addParentsGuides(Set<TVSeriesParentsGuide> valueSet) {
        addAllIfChange(this.parentsGuides, valueSet);
    }

    public Set<TVSeriesAttrbute> getAttribute() {
        return Sets.newHashSet(this.attributes.values());
    }

    public void setAttribute(Set<VideoAttribute> valueSet) {
        setAll(this.attributes, valueSet);
    }

    public void addAttribute(Set<VideoAttribute> valueSet) {
        addAllIfChange(this.attributes, valueSet);
    }

    public void addAttribute(VideoAttribute v) {
        addIfChange(this.attributes, v, null);
    }


    @Override
    public Set<Object> getToBeDelSet() {
        setToBeDel(trailers);
        setToBeDel(artworks);
        setToBeDel(synopsises);
        setToBeDel(userReviews);
        setToBeDel(genres);
        setToBeDel(countries);
        setToBeDel(certs);
        setToBeDel(similars);
        setToBeDel(releaseInfos);
        setToBeDel(casts);
        setToBeDel(titleAkas);
        setToBeDel(awards);
        setToBeDel(parentsGuides);
        setToBeDel(attributes);
        setToBeDel(seasons);
        setToBeDel(episodes);
        return super.getToBeDelSet();
    }
}
