package com.valor.mfc.vms.meta.model.database.tools.media;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.meta.model.database.constants.EMetaProperty;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;

/**
 * Created by Frank.Huang on 2016/12/14.
 */
public class SortScoreTools {
    public static final int SORT_FACTOR_ASIA_FILM = -33333333;
    public static final int SORT_FACTOR_NO_IMAGE  = -44444444;
    public static final int SORT_FACTOR_NO_RATING = -55555555;
    public static final int SORT_FACTOR_MIN = SORT_FACTOR_ASIA_FILM+SORT_FACTOR_NO_IMAGE+SORT_FACTOR_NO_RATING;


    public static int getSortScore(Meta4Query m4q){
        int score = m4q.getReleaseDate() > 0 ? m4q.getReleaseDate() : 0;

        //没图片
        if ((m4q.getHasArtwork()& EMetaProperty.META_ARTWORK_POSTTER.getValue()) == 0) {
            score += SORT_FACTOR_NO_IMAGE;
        }

        //没评分
        if (m4q.getRating() <= 0) {
            score += SORT_FACTOR_NO_RATING;
        }

        //电影亚洲非英语
        if (m4q.getType() == EVideoType.MOVIE && m4q.getIsAsia() == 1 && m4q.getLangNotContainsEn() == 1) {
            score += SORT_FACTOR_ASIA_FILM;
        }

        //亚洲电视剧
        if (m4q.getType() == EVideoType.SERIES && m4q.getIsAsia() == 1) {
            score += SORT_FACTOR_ASIA_FILM;
        }

        return score;
    }
}
