package com.valor.mfc.vms.meta.model.service;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.mfc.vms.meta.model.database.constants.ETopicType;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.mm.OssPlaylistTopicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/6/17.
 */
@Deprecated
@Service
public class TopicTypeService {
    private static final Logger logger = LoggerFactory.getLogger(TopicTypeService.class);

    @Autowired
    private MetaDao metaDao;

    private static Map<Integer,String> topicTypeMap = Maps.newConcurrentMap();
    private static Map<String,Integer> url2TypeMap = Maps.newConcurrentMap();

    @PostConstruct
    public void loadFromDB(){
        Set<OssPlaylistTopicType> values = metaDao.getSetData(false,OssPlaylistTopicType.class,null);
        if (!values.isEmpty()){
            values.forEach(e->{
                topicTypeMap.put(e.getTopicType(),e.getName());
                if (!Strings.isNullOrEmpty(e.getUrl())){
                    url2TypeMap.put(e.getUrl(),e.getTopicType());
                }

            });
            logger.info("Load [{}] topic type from database",topicTypeMap.size());
        }
    }

    public String getTopicName(ETopicType type){
        return topicTypeMap.getOrDefault(type.getValue(),"");
    }

    public String getTopicName(int type){
        return topicTypeMap.getOrDefault(type,"");
    }

    public ETopicType getTopicTypeByURL(String url){
        return ETopicType.valueOf(url2TypeMap.getOrDefault(url,ETopicType.UNKNOWN.value));
    }

}
