/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.tools.linked;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;

public class LinkedMediaWrapper {
    private AbstractMedia media = null;

    public LinkedMediaWrapper(AbstractMedia media) {
        this.media = media;
    }

    public long getMediaId() {
        if (this.media == null) {
            return -1L;
        }
        return this.media.getId();
    }

    public EVideoType getMediaType() {
        if (this.media == null) {
            return EVideoType.UNKNOWN;
        }
        return this.media.getType();
    }

    public int getPopularity() {
        if (this.media == null) {
            return 0;
        }
        return Double.valueOf(this.media.getPopularity()).intValue();
    }

    public int getWR() {
        if (this.media == null) {
            return 0;
        }
        return (int)(this.media.getWR() * 10000.0);
    }

    public int getReleaseDate() {
        if (this.media == null) {
            return 0;
        }
        return DateTimeTools.date2IntVal((String)this.media.getReleaseDate());
    }

    public double getRating() {
        if (this.media == null) {
            return 0.0;
        }
        return this.media.getRating();
    }

    public int getYear() {
        if (this.media == null) {
            return 0;
        }
        return this.media.getPublicationYear();
    }

    public long getDataVersion() {
        if (this.media == null) {
            return -1L;
        }
        return this.media.getDataVersion();
    }

    public String getMetaId() {
        if (this.media == null) {
            return "";
        }
        return this.media.getMetaId();
    }

    public String getImdbId() {
        if (this.media == null) {
            return "";
        }
        return this.media.getImdbId();
    }
}

