/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.cloud.CloudAudioLanguageDdo;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudAudioLanguageService {
    private static Map<Integer, String> codeLanguageMap = Maps.newHashMap();
    private static Map<String, Integer> languageCodeMap = Maps.newHashMap();
    @Autowired
    private MetaDao metaDao;

    @PostConstruct
    public void load() {
        Set audioLanguageDdos = this.metaDao.getSetData(false, CloudAudioLanguageDdo.class, null);
        audioLanguageDdos.forEach(e -> {
            codeLanguageMap.put(e.getCode(), e.getLanguage());
            languageCodeMap.put(e.getLanguage(), e.getCode());
        });
    }

    public long languages2Num(List<String> languages) {
        BitSet bitSet = new BitSet();
        languages.forEach(e -> {
            int index;
            if (languageCodeMap.containsKey(e) && (index = languageCodeMap.get(e) - 1) >= 0 && index < 64) {
                BitSet languageBitSet = new BitSet();
                languageBitSet.set(index);
                bitSet.or(languageBitSet);
            }
        });
        long[] bits = bitSet.toLongArray();
        return bits.length > 0 ? bits[0] : 0L;
    }

    public List<String> num2Languages(long languageNum) {
        ArrayList languages = Lists.newArrayList();
        String binaryString = Long.toBinaryString(languageNum);
        char[] languageChars = binaryString.toCharArray();
        int code = 1;
        for (int i = languageChars.length - 1; i > 0; --i) {
            if ('1' == languageChars[i] && codeLanguageMap.containsKey(code)) {
                String language = codeLanguageMap.get(code);
                languages.add(language);
            }
            ++code;
        }
        return languages;
    }
}

