package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractGenre extends AbstractId {
    @Id
    @Column(name="data_id")
    public long dataId;

    public long getDataId() {
        return dataId;
    }

    public void setDataId(long dataId) {
        this.dataId = dataId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractGenre that = (AbstractGenre) o;

        return Objects.equal(this.dataId, that.dataId) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(dataId, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,dataId);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }
}
