package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/7/26.
 */
@MappedSuperclass
public abstract class AbstractParentsGuide extends AbstractLocaleId {
    @Id
    @Column(name = "sn")
    public Integer sn = 0;

    @Column(name = "label",length = 255)
    private String label ;

    @Column(name = "publish_date",length = 20)
    private String publishDate;

    @Lob
    @Column(name = "text")
    private String text;

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }


    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractParentsGuide that = (AbstractParentsGuide) o;

        return Objects.equal(this.sn, that.sn) &&
                Objects.equal(this.language, that.language) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(sn, language, id);
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,language,sn);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractParentsGuide that = (AbstractParentsGuide) o;

            return Objects.equal(this.label,that.label)
                    && Objects.equal(this.publishDate,that.publishDate)
                    && Objects.equal(this.text,that.text);
        }
    }
}
