package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractSubtitle extends AbstractId {
    @Id
    @Column(name="subtitle")
    public long subtitle;

    @Column(name="type")
    protected EVideoType type;

    public long getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(long subtitle) {
        this.subtitle = subtitle;
    }

    public EVideoType getType() {
        return type;
    }

    public void setType(EVideoType type) {
        this.type = type;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,subtitle);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractSubtitle that = (AbstractSubtitle) o;

        return Objects.equal(this.subtitle, that.subtitle) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(subtitle, id);
    }
}
