package com.valor.mfc.vms.meta.model.database.ddo.media.video;

import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractSubtitle;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * Created by Chris.Zeng on 2021/12/2.
 */
@Entity
@Table(name="vms_video_subtitle",indexes={@Index(name="seriesIdIndex",columnList="series_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class VideoSubtitle extends AbstractSubtitle {
    @Column(name = "series_id")
    private long seriesId = 0;

    @Column(name = "season",columnDefinition="int default -1")
    private int season = -1;

    @Column(name = "episode",columnDefinition="int default -1")
    private int episode = -1;

    public long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(long seriesId) {
        this.seriesId = seriesId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }
}
