package com.valor.mfc.vms.meta.model.database.ddo.playlist.common;


import com.valor.mfc.vms.meta.model.database.constants.EListLanguage;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;


/**
 * playlist Database Data Object.
 */
@Entity
@Table(name = "vms_playlist")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PlaylistDDO extends AbstractPlaylist {

    @Column(name = "app_id", length = 128)
    private String appId = "";

    @Column(name = "release_id", length = 128)
    private String releaseId = "";
    @Column(name="open_state",columnDefinition = "int(2) default 0 COMMENT '开放状态，0-全部开放，1-品牌/型号开放，2-不开放'")
    private int openState;
    @Column(name = "open_brands",columnDefinition = "varchar(1024) default '' COMMENT '开放品牌，open_state =1时可用,品牌1:型号1, 型号2;品牌2:型号2…'")
    private String openBrands;
    @Column(name="logo",columnDefinition = "varchar(255) default '' COMMENT 'logo'")
    private String logo;
    @Column(name="logo2",columnDefinition = "varchar(255) default '' COMMENT 'logo2,用于帮助前端控制动态效果'")
    private String logo2;

    @Column(name="pl_id",columnDefinition = "varchar(2047) default '' COMMENT 'logo'")
    private String plId = "";

    @Column(name = "update_status",columnDefinition="int default 0")
    private int updateStatus;

    @Column(name="background_image",columnDefinition = "varchar(512) default ''" )
    private String backgroundImage="";

    @Column(name="list_language")
    @Enumerated(EnumType.STRING)
    private EListLanguage listLanguage;

    @Column(name="list_region", columnDefinition = "varchar(32) default 'default'")
    private String listRegion;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public int getOpenState() {
        return openState;
    }

    public void setOpenState(int openState) {
        this.openState = openState;
    }

    public String getOpenBrands() {
        return openBrands;
    }

    public void setOpenBrands(String openBrands) {
        this.openBrands = openBrands;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLogo2() {
        return logo2;
    }

    public void setLogo2(String logo2) {
        this.logo2 = logo2;
    }

    public EListLanguage getListLanguage() {
        return listLanguage;
    }

    public void setListLanguage(EListLanguage listLanguage) {
        this.listLanguage = listLanguage;
    }

    public String getPlId() {
        return plId;
    }

    public void setPlId(String plId) {
        this.plId = plId;
    }

    public int getUpdateStatus() {
        return updateStatus;
    }

    public void setUpdateStatus(int updateStatus) {
        this.updateStatus = updateStatus;
    }

    public String getBackgroundImage() {
        return backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public String getListRegion() {
        return listRegion;
    }

    public void setListRegion(String listRegion) {
        this.listRegion = listRegion;
    }
}
