package com.valor.mfc.vms.meta.model.database.ddo.notice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.mfc.vms.api.model.notice.*;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * Description :
 * Author      : Frank
 * Created     : 2015/9/4
 */
@Entity
@Table(name = "vms_notice")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class NoticeDdo extends AbstractLMI {

    @Id
    @GeneratedValue
    @Column(name = "notice_id")
    private Long noticeId;

    @Column(name = "region", columnDefinition = "varchar(16) default 'default'")
    private String region;

    @Column(name = "language", columnDefinition = "varchar(16) default 'default'")
    private String language;

    @Basic(optional = false)
    @Enumerated(EnumType.STRING)
    @Column(name = "notice_type", length = 32)
    private ENoticeType noticeType;

    @Enumerated(EnumType.STRING)
    @Column(name = "frequency", length = 32)
    private ENoticeFrequency frequency = ENoticeFrequency.ALWAYS;

    @Column(name = "priority")
    private int priority;

    @Basic(optional = false)
    @Column(name = "title")
    private String title;

    @Basic(optional = false)
    @Column(name = "message", length = 1024)
    private String message;

    @Column(name = "image", length = 256)
    private String image;

    @Column(name = "url", length = 256)
    private String url;

    @Column(name = "start_time_2", length = 20)
    private String startTime2;

    @Column(name = "end_time_2", length = 20)
    private String endTime2;

    @Column(name = "status", length = 32)
    @Enumerated(EnumType.STRING)
    private ENoticeStatus status = ENoticeStatus.NORMAL;

    @Column(name = "user_type", columnDefinition = "int(11) default 0")
    private int userType = ENoticeUserType.ALL.ordinal();

    @Column(name = "login_type", columnDefinition = "int(11) default 0")
    private int loginType = ENoticeLoginType.ALL.ordinal();

    //因box和手机端的分辨率不同，所以不做通用设置
    @Column(name = "device_type", columnDefinition = "tinyint(4) default 0 COMMENT '设备类型（0 box 1phone）'")
    private int deviceType = ENoticeLoginDeviceType.BOX.ordinal();

    @Column(name = "plan_type", columnDefinition = "int(11) default 0")
    private int planType = ENoticePlanType.ALL.ordinal();

    @Column(name = "source_channel", columnDefinition = "int(11) default 0")
    private int sourceChannel = ENoticeApkSourceType.ALL.ordinal();

    @Column(name = "service_status", columnDefinition = "int(11) default 0")
    private int serviceStatus = ENoticeServiceStatus.ALL.ordinal();

    @Column(name = "product_model", nullable = false, columnDefinition = "varchar(256) default 'ALL'")
    private String productModel;

    @Column(name = "app_ver_min")
    private Long appVerMin;

    @Column(name = "app_ver_max")
    private Long appVerMax;

    /////////////////////////////////////////////////////


    public int getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public ENoticeType getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(ENoticeType noticeType) {
        this.noticeType = noticeType;
    }


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonIgnore
    public ENoticeStatus getStatus() {
        return status;
    }

    public void setStatus(ENoticeStatus status) {
        this.status = status;
    }

    public ENoticeFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(ENoticeFrequency frequency) {
        this.frequency = frequency;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getStartTime2() {
        return startTime2;
    }

    public void setStartTime2(String startTime2) {
        this.startTime2 = startTime2;
    }

    public String getEndTime2() {
        return endTime2;
    }

    public void setEndTime2(String endTime2) {
        this.endTime2 = endTime2;
    }

    public int getUserType() {
        return userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public int getLoginType() {
        return loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public int getPlanType() { return planType; }

    public void setPlanType(int planType) { this.planType = planType; }

    public int getSourceChannel() {
        return sourceChannel;
    }

    public void setSourceChannel(int sourceChannel) {
        this.sourceChannel = sourceChannel;
    }

    public int getServiceStatus() {
        return serviceStatus;
    }

    public void setServiceStatus(int serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public String getProductModel() {
        return productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public Long getAppVerMin() {
        return appVerMin;
    }

    public void setAppVerMin(Long appVerMin) {
        this.appVerMin = appVerMin;
    }

    public Long getAppVerMax() {
        return appVerMax;
    }

    public void setAppVerMax(Long appVerMax) {
        this.appVerMax = appVerMax;
    }
}
