package com.valor.mfc.vms.meta.model.database.tools.linked;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;

/**
 * Created by Frank.Huang on 2016/6/27.
 */
public class LinkedMediaWrapper {
    private AbstractMedia media = null;

    public LinkedMediaWrapper(AbstractMedia media) {
        this.media = media;
    }

    public long getMediaId(){
        if (media==null){
            return -1;
        }

        return media.getId();
    }

    public EVideoType getMediaType(){
        if (media==null){
            return EVideoType.UNKNOWN;
        }

        return media.getType();
    }

    public int getPopularity(){
        if (media==null){
            return 0;
        }

        return Double.valueOf(media.getPopularity()).intValue();
    }

    public int getWR(){
        if (media==null){
            return 0;
        }

        return (int) (media.getWR() * 10000);
    }


    public int getReleaseDate(){
        if (media==null){
            return 0;
        }

        return DateTimeTools.date2IntVal(media.getReleaseDate());
    }

    public double getRating(){
        if (media==null){
            return 0.0;
        }

        return media.getRating();
    }

    public int getYear(){
        if (media==null){
            return 0;
        }

        return media.getPublicationYear();
    }

    public long getDataVersion(){
        if (media==null){
            return -1;
        }

        return media.getDataVersion();
    }

    public String getMetaId(){
        if (media==null){
            return "";
        }

        return media.getMetaId();
    }

    public String getImdbId(){
        if (media==null){
            return "";
        }

        return media.getImdbId();
    }
}
