package com.valor.mfc.vms.meta.model.database.tools.media;

import com.google.common.base.Strings;

/**
 * Created by Frank.Huang on 2016/10/11.
 */
public enum ETVCertificateUS {
    NR("NR",0),
    TV_Y("TV-Y",100),
    TV_Y7("TV-Y7",101),
    TV_G("TV-G",102),
    TV_PG("TV-PG",103),
    TV_14("TV-14",104),
    TV_MA("TV-MA",105),
    TV_M("TV-M",105)
    ;

    private String k;
    private int v;

    ETVCertificateUS(String k, int v) {
        this.k = k;
        this.v = v;
    }

    public static ETVCertificateUS stringValueOf(String k){
        if (!Strings.isNullOrEmpty(k)){
            for (ETVCertificateUS e:values()){
                if (e.k.equalsIgnoreCase(k)){
                    return e;
                }
            }
        }

        return ETVCertificateUS.NR;
    }

    public boolean lt(ETVCertificateUS c1){
        return v < c1.v;
    }

    public boolean le(ETVCertificateUS c1){
        return v <= c1.v;
    }

    public boolean gt(ETVCertificateUS c1){
        return v > c1.v;
    }

    public boolean lt(String k){
        return lt(stringValueOf(k));
    }

    public boolean gt(String k){
        return gt(stringValueOf(k));
    }

    public boolean le(String k){
        return le(stringValueOf(k));
    }
}
