/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.service;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.mfc.vms.meta.model.database.constants.EListLanguage;
import com.valor.mfc.vms.meta.model.database.constants.ETopicType;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.mm.OssPlaylistTopicType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class TopicTypeService {
    private static final Logger logger = LoggerFactory.getLogger(TopicTypeService.class);
    @Autowired
    private MetaDao metaDao;
    private static Map<Integer, String> topicTypeMap = Maps.newConcurrentMap();
    private static Map<String, Integer> url2TypeMap = Maps.newConcurrentMap();
    private static Map<Integer, EListLanguage> topicTypeLanguageMap = Maps.newConcurrentMap();

    @PostConstruct
    public void loadFromDB() {
        Set values = this.metaDao.getSetData(false, OssPlaylistTopicType.class, null);
        if (!values.isEmpty()) {
            values.forEach(e -> {
                topicTypeMap.put(e.getTopicType(), e.getName());
                topicTypeLanguageMap.put(e.getTopicType(), Objects.isNull((Object)e.getListLanguage()) ? EListLanguage.ALL : e.getListLanguage());
                if (!Strings.isNullOrEmpty((String)e.getUrl())) {
                    url2TypeMap.put(e.getUrl(), e.getTopicType());
                }
            });
            logger.info("Load [{}] topic type from database", (Object)topicTypeMap.size());
        }
    }

    public String getTopicName(ETopicType type) {
        return topicTypeMap.getOrDefault(type.getValue(), "");
    }

    public EListLanguage getTopicListLanguage(int type) {
        return topicTypeLanguageMap.getOrDefault(type, EListLanguage.ALL);
    }

    public String getTopicName(int type) {
        return topicTypeMap.getOrDefault(type, "");
    }

    public ETopicType getTopicTypeByURL(String url) {
        return ETopicType.valueOf(url2TypeMap.getOrDefault(url, ETopicType.UNKNOWN.value));
    }
}

