package com.valor.mfc.vms.meta.model.database.ddo.playlist.kids;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/6/23.
 */
@Entity
@Table(name = "vms_kids_videos",indexes = {
    @Index(name = "idx_update_status",columnList = "update_status"),
    @Index(name = "idx_mediaId",columnList = "media_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class KidsVideosDdo extends AbstractLMI {
    @Id
    @Column(name = "pid",columnDefinition = "bigint(20) default -1 COMMENT '列表ID'")
    private long pid;
    @Id
    @Column(name = "media_id",columnDefinition = "bigint(20) default -1 COMMENT '影片ID'")
    private long mediaId;
    @Column(name = "update_status",columnDefinition = "int(2) default 0 COMMENT '更新状态,0-未更新，1-已更新'")
    private int updateStatus = 0;
    @Column(name = "show_seq",columnDefinition = "bigint(20) default 0 COMMENT '展示序号'")
    private long showSeq;
    @Column(name = "status",columnDefinition = "int(2) default 0 COMMENT '状态,0-disables，1-可用'")
    private int status;
    @Column(name = "source",columnDefinition = "int(2) default 0 COMMENT '来源,0-筛选，1-抓取，2-人工'")
    private int source;

    public long getPid() {
        return pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public int getUpdateStatus() {
        return updateStatus;
    }

    public void setUpdateStatus(int updateStatus) {
        this.updateStatus = updateStatus;
    }

    public long getShowSeq() {
        return showSeq;
    }

    public void setShowSeq(long showSeq) {
        this.showSeq = showSeq;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSource() {
        return source;
    }

    public void setSource(int source) {
        this.source = source;
    }
}
