package com.valor.mfc.vms.meta.model.database.tools.media;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import com.valor.mfc.vms.api.model.constant.EArtworkType;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.api.model.constant.ImageLevel;
import com.valor.mfc.vms.common.tools.meta.LanguageTools;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.constants.EMetaModifyProperty;
import com.valor.mfc.vms.meta.model.database.constants.EMetaProperty;
import com.valor.mfc.vms.meta.model.database.constants.MMDataFlag;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractCountry;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractGenre;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.Series;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.Video;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCertification;
import com.valor.mfc.vms.meta.model.database.tools.BitTools;
import com.valor.mfc.vms.meta.model.service.SyncFieldTools;

import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/8/16.
 */
public class Meta4QueryWrapper {

    private static Set<Long> GENRE_FAMILY    = ImmutableSet.of(8L);
    private static Set<Long> GENRE_FAMILY_EXCLUDE    = ImmutableSet.of(12L); //排除恐怖片
    private static Set<Long> GENRE_ANIMATION = ImmutableSet.of(3L);
    private static Set<Long> REGION_US      = ImmutableSet.of(227L);

    /**
     * +-----+------+--------------------+
     * | id  | code | name               |
     * +-----+------+--------------------+
     * |  10 | AR   | Argentina          |
     * |  26 | BO   | Bolivia            |
     * |  30 | BR   | Brazil             |
     * |  43 | CL   | Chile              |
     * |  47 | CO   | Colombia           |
     * |  52 | CR   | Costa Rica         |
     * |  55 | CU   | Cuba               |
     * |  61 | DO   | Dominican Republic |
     * |  63 | EC   | Ecuador            |
     * |  65 | SV   | El Salvador        |
     * |  76 | GF   | French Guiana      |
     * |  88 | GP   | Guadeloupe         |
     * |  90 | GT   | Guatemala          |
     * |  94 | HT   | Haiti              |
     * |  96 | HN   | Honduras           |
     * | 133 | MQ   | Martinique         |
     * | 137 | MX   | Mexico             |
     * | 154 | NI   | Nicaragua          |
     * | 166 | PA   | Panama             |
     * | 168 | PY   | Paraguay           |
     * | 169 | PE   | Peru               |
     * | 173 | PT   | Portugal           |
     * | 174 | PR   | Puerto Rico        |
     * | 198 | ES   | Spain              |
     * | 229 | UY   | Uruguay            |
     * | 233 | VE   | Venezuela          |
     * +-----+------+--------------------+
     */

    private static Set<Long> REGION_LATIN   = ImmutableSet.of(10L,26L,30L,43L,47L,52L,55L,61L,63L,
                                                              65L,76L,88L,90L,94L,96L,133L,137L,154L,
                                                              166L,168L,169L,173L,174L,198L,229L,233L);


//    +-----+------+-------------+
//    | id  | code | name        |
//    +-----+------+-------------+
//    |  44 | CN   | China       |
//    |  97 | HK   | Hong Kong   |
//    | 100 | IN   | India       |
//    | 109 | JP   | Japan       |
//    | 197 | KR   | South Korea |
//    | 209 | TW   | Taiwan      |
//     +-----+------+-------------+

    private static Set<Long> REGION_ASIA   = ImmutableSet.of(44L,97L,100L,109L,197L,209L);

    private Meta4Query meta4Query;
    private MetaFlagWrapper flagWrapper = new MetaFlagWrapper();
    private String field = "";

    private static final String KEY_FAMILY_GENRE = "KEY_FAMILY_GENRE";
    private static final String KEY_FAMILY_CERT  = "KEY_FAMILY_CERT";
    private Map<String,Integer> familyMap = Maps.newHashMap();


    public Meta4QueryWrapper(Meta4Query meta4Query, String field) {
        this.field = field;
        if (meta4Query != null) {
            this.meta4Query = meta4Query;
            this.meta4Query.setLastModifyTime(new Date());
        } else {
            this.meta4Query = new Meta4Query();
        }

        this.meta4Query.setToBeDel(MMDataFlag.TO_BE_DEL);
    }

    public void setMeta4Query(Meta4Query meta4Query) {
        this.meta4Query = meta4Query;
    }


    private boolean isTV(){
        return (meta4Query.getType() == EVideoType.SERIES);
    }

    private boolean isMovie(){
        return (meta4Query.getType() == EVideoType.MOVIE);
    }

    private boolean isTVReduceWight(){
        if (isTV() && meta4Query.getIsAsia() == 1) {
            return true;
        } else {
            return false;
        }
    }

    private boolean isReduceWight(String field, int rating, int hasArtwork){
        if ((SyncFieldTools.isMeta(field) && rating <=0) || !BitTools.isSet(hasArtwork, 1)){
            return true;
        }

        if ((SyncFieldTools.isImage(field) && !BitTools.isSet(hasArtwork, 1)) || rating <=0){
            return true;
        }

        return false;
    }

    private Meta4Query updateSortFactor(){
        /*
         * 没有图片和评分的影片,让影片拍在列表的后面(按照ReleaseDate顺序)
         *    排序值 = ReleaseDate + SORT_FACTOR_MIN(负值)
         */
        if (isReduceWight(field, meta4Query.getRating(), meta4Query.getHasArtwork())){
            int sortScore = SortScoreTools.getSortScore(meta4Query);
            if (sortScore != meta4Query.getReleaseDate()){
                if (sortScore >= 0) {
                    sortScore += SortScoreTools.SORT_FACTOR_MIN;
                }

                if (meta4Query.getReleaseDate() != sortScore){
                    meta4Query.setToBeDel(0);
                    meta4Query.setReleaseDate(sortScore);
                }

                if (meta4Query.getPopularity() != sortScore) {
                    meta4Query.setToBeDel(0);
                    meta4Query.setPopularity(sortScore);
                }

                if (meta4Query.getWeightRating() != sortScore){
                    meta4Query.setToBeDel(0);
                    meta4Query.setWeightRating(sortScore);
                }

                if (isTVReduceWight() && meta4Query.getLastAirDate() != sortScore){
                    meta4Query.setLastAirDate(sortScore);
                    meta4Query.setToBeDel(0);
                }
            }
        }

        return meta4Query;
    }

    public Meta4Query getMeta4Query() {
        updateSortFactor();
//        if (meta4Query.getToBeDel() != MMDataFlag.TO_BE_DEL){
//            meta4Query.setLastModifyTime(new Date());
//            return meta4Query;
//        }else {
//            return null;
//        }
        meta4Query.setLastModifyTime(new Date());
        return meta4Query;
    }

    public int getMetaFlag(){
       return flagWrapper.getMetaFlag();
    }

    public int getModifyFlag(){
        return flagWrapper.getModifyFlag();
    }

    public void updateMetaFlag(AbstractMedia media){

        meta4Query.setId(media.getId());

        if (meta4Query.getType() != media.getType()){
            meta4Query.setToBeDel(0);
            meta4Query.setType(media.getType());
        }

        if (!meta4Query.getMetaId().equalsIgnoreCase(media.getMetaId())){
            meta4Query.setToBeDel(0);
            meta4Query.setMetaId(media.getMetaId());
        }

        if (meta4Query.getReleaseDate() != media.getReleaseDateInt()){
            meta4Query.setToBeDel(0);
            meta4Query.setReleaseDate(media.getReleaseDateInt());
        }

        long popularity = Double.valueOf(media.getPopularity()).longValue();
        if (meta4Query.getPopularity() != popularity) {
            meta4Query.setToBeDel(0);
            meta4Query.setPopularity(popularity);
        }

        int wr = (int) (media.getWR() * 10000);
        if (meta4Query.getWeightRating() != wr){
            meta4Query.setToBeDel(0);
            meta4Query.setWeightRating(wr);
        }

        int rating = (int)(media.getRating() * 10);
        if (meta4Query.getRating() != rating){
            meta4Query.setToBeDel(0);
            meta4Query.setRating(rating);
        }

        if (meta4Query.getYear()!= media.getPublicationYear()){
            meta4Query.setToBeDel(0);
            meta4Query.setYear(media.getPublicationYear());
        }

        int hasRuntime =  media.getRuntime()>0?1:0;
        if (meta4Query.getHasRuntime() != hasRuntime){
            meta4Query.setToBeDel(0);
            meta4Query.setHasRuntime(hasRuntime);
        }

        if (meta4Query.getVoteCount()!= media.getVoteCount()){
            meta4Query.setToBeDel(0);
            meta4Query.setVoteCount(media.getVoteCount());
        }

        int adult = 0;
        if (media.getAdult()==1 || BitTools.isSet(media.getComplete(), EMetaProperty.META_PORNOGRAPHIC.getValue())){
            adult =1;
        }

        if (meta4Query.getAdult()!=adult){
            meta4Query.setToBeDel(0);
            meta4Query.setAdult(adult);
        }

        //tv series set last air date
        if (media instanceof Series){
            int lastAirDate = DateTimeTools.date2IntVal(((Series) media).getLastAirDate());
            if (meta4Query.getLastAirDate() != lastAirDate){
                meta4Query.setLastAirDate(lastAirDate);
                meta4Query.setToBeDel(0);
            }
        }else if (media instanceof Video){
            int lastAirDate = ((Video) media).getReleaseDateInt();
            if (meta4Query.getLastAirDate() != lastAirDate){
                meta4Query.setLastAirDate(lastAirDate);
                meta4Query.setToBeDel(0);
            }
        }

        boolean isEnglish = LanguageTools.isContainEnglish(media.getOriginalLanguage());
        int hasEnglish = isEnglish?0:1;
        if (meta4Query.getLangNotContainsEn() != hasEnglish){
            meta4Query.setLangNotContainsEn(hasEnglish);
            meta4Query.setToBeDel(0);
        }
    }

    private void updateFamily(){
        if (familyMap.size() != 2){
            return;
        }

        int v = familyMap.getOrDefault(KEY_FAMILY_GENRE,0) & familyMap.getOrDefault(KEY_FAMILY_CERT,0);
        if (meta4Query.getIsFamily() != v){
            meta4Query.setIsFamily(v);
            meta4Query.setToBeDel(0);

            if (v==1){
                flagWrapper.setMetaFlag(EMetaProperty.META_FAMILY_FILM);
            }else {
                flagWrapper.clsMetaFlag(EMetaProperty.META_FAMILY_FILM);
            }
        }
    }

    public void updateCertFlag(Set set){
        if (!SyncFieldTools.isMeta(field)){
            return;
        }

        if (!CollectionUtils.isNullOrEmpty(set)){
            for (Object e:set){
                AbstractCertification c = (AbstractCertification) e;
                if ("us".equalsIgnoreCase(c.countryCode.toLowerCase())){
                    if (e instanceof VideoCertification){
                        if (EMovieCertificateUS.PG_13.le(c.getCertificate())){
                            familyMap.put(KEY_FAMILY_CERT, 0);
                        }
                    }

                    if (e instanceof TVSeriesCertification){
                        if (ETVCertificateUS.TV_14.le(c.getCertificate())){
                            familyMap.put(KEY_FAMILY_CERT, 0);
                        }
                    }
                }
            }
        }else {
            familyMap.put(KEY_FAMILY_CERT,1);
        }

        updateFamily();
    }

    public void updateGenreFlag(Set genreSet){
        if (!SyncFieldTools.isMeta(field)){
            return;
        }

        if (CollectionUtils.isNullOrEmpty(genreSet)){
            familyMap.put(KEY_FAMILY_GENRE, 0);
            return;
        }

        Set<Long> genreIds = Sets.newHashSet();
        genreSet.forEach(e->{
            AbstractGenre g = (AbstractGenre) e;
            genreIds.add(g.getDataId());
        });

        if (CollectionUtils.isContains(genreIds,GENRE_FAMILY)
            && !CollectionUtils.isContains(genreIds,GENRE_FAMILY_EXCLUDE)){
            familyMap.put(KEY_FAMILY_GENRE, 1);
        }else {
            familyMap.put(KEY_FAMILY_GENRE, 0);
        }

        updateFamily();

        int isAnimation = 0;
        if (CollectionUtils.isContains(genreIds,GENRE_ANIMATION)) {
            isAnimation = 1;
        }

        if (meta4Query.getIsAnimation() != isAnimation){
            meta4Query.setIsAnimation(isAnimation);
            meta4Query.setToBeDel(0);
            if (isAnimation == 1){
                flagWrapper.setMetaFlag(EMetaProperty.META_ANIMATION_FILM);
            }else {
                flagWrapper.clsMetaFlag(EMetaProperty.META_ANIMATION_FILM);
            }
        }
    }

    public void updateRegionFlag(Set set){
        if (CollectionUtils.isNullOrEmpty(set)){
            return;
        }

        if (!SyncFieldTools.isMeta(field)){
            return;
        }

        final int KEY_ISHOLLYWOOD = 1;
        final int KEY_ISLATIN = 2;
        final int KEY_ISASIA = 3;
        Map<Integer,Integer> mapRegion = Maps.newHashMap();

        set.forEach(e->{
            AbstractCountry g = (AbstractCountry) e;
            if (REGION_US.contains(g.getDataId())){
                mapRegion.put(KEY_ISHOLLYWOOD,1);
            }

            if (REGION_LATIN.contains(g.getDataId())){
                mapRegion.put(KEY_ISLATIN,1);
            }

            if (REGION_ASIA.contains(g.getDataId())){
                mapRegion.put(KEY_ISASIA,1);
            }
        });

        int isHollywood = mapRegion.getOrDefault(KEY_ISHOLLYWOOD,0);
        if (meta4Query.getIsHollywood() != isHollywood){
            if (isHollywood == 1){
                flagWrapper.setMetaFlag(EMetaProperty.META_HOLLYWOOD_FILM);
            }else {
                flagWrapper.clsMetaFlag(EMetaProperty.META_HOLLYWOOD_FILM);
            }
            meta4Query.setIsHollywood(isHollywood);
            meta4Query.setToBeDel(0);
        }

        int isAsia = mapRegion.getOrDefault(KEY_ISASIA,0);
        if (meta4Query.getIsAsia() != isAsia){
            if (isAsia==1){
                flagWrapper.setMetaFlag(EMetaProperty.META_ASIA_FILM);
            }else {
                flagWrapper.clsMetaFlag(EMetaProperty.META_ASIA_FILM);
            }

            meta4Query.setIsAsia(isAsia);
            meta4Query.setToBeDel(0);
        }

        int isLatin = mapRegion.getOrDefault(KEY_ISLATIN,0);
        if (meta4Query.getIsLatin() != isLatin){
            if (isLatin == 1) {
                flagWrapper.setMetaFlag(EMetaProperty.META_LATIN_FILM);
            } else {
                flagWrapper.clsMetaFlag(EMetaProperty.META_LATIN_FILM);
            }
            meta4Query.setIsLatin(isLatin);
            meta4Query.setToBeDel(0);
        }
    }



    public void updateArtworkFlag(Set set,MetaModifyFlagWrapper modifyFlagWrapper){
        if (CollectionUtils.isNullOrEmpty(set)){
            return;
        }

//        imdb转化是先转meta，再转image，pp转化直接meta、image一起转，所以之类不能做限制。
//        if (!SyncFieldTools.isImage(field)){
//            return;
//        }

        int hasArtwork = getImageFlag2(set,modifyFlagWrapper);
        if (meta4Query.getHasArtwork() != hasArtwork){
            meta4Query.setHasArtwork(hasArtwork);
            meta4Query.setToBeDel(0);
        }
    }

    public int getImageFlag2(Set set, MetaModifyFlagWrapper modifyFlagWrapper) {
        int hasArtwork = 0;

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER.getValue())){
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER.getValue();
        }

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP)) {
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP.getValue();
        }

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_ES.getValue())){
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_ES);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_ES.getValue();
        }

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_ES)) {
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_ES);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_ES.getValue();
        }

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_PT.getValue())){
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_PT);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_PT.getValue();
        }

        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_PT)) {
            flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_PT);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_PT.getValue();
        }

        if (!CollectionUtils.isNullOrEmpty(set)){
            for (Object e : set) {
                AbstractArtwork v = (AbstractArtwork) e;
                if (v.getMaster() == ImageLevel.IMG_MASTER && EArtworkType.POSTER == v.getArtworkType()) {
                    if (v.getLanguage().equalsIgnoreCase("en")){
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER.getValue();
                    }else if (v.getLanguage().equalsIgnoreCase("es")){
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_ES);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_ES.getValue();
                    }else if (v.getLanguage().equalsIgnoreCase("pt")){
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_PT);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_PT.getValue();
                    }
                }

                if (v.getMaster() == ImageLevel.IMG_MASTER && EArtworkType.BACKDROP == v.getArtworkType()) {
                    if (v.getLanguage().equalsIgnoreCase("en")) {
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
                        hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP.getValue();
                    }else if (v.getLanguage().equalsIgnoreCase("es")){
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_ES);
                        hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_ES.getValue();
                    }else if (v.getLanguage().equalsIgnoreCase("pt")){
                        flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_PT);
                        hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_PT.getValue();
                    }
                }
            }
        }

        return hasArtwork;
    }
    public int getImageFlag(Set set) {
        int hasArtwork = 0;
        for (Object e :set){
            AbstractArtwork v = (AbstractArtwork) e;
            if (v.getMaster() == 1 && !Strings.isNullOrEmpty(v.getUrl())){
                if (EArtworkType.POSTER == v.getArtworkType()){
                    flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
                    hasArtwork += EMetaProperty.META_ARTWORK_POSTTER.getValue();
                }

                if (EArtworkType.BACKDROP == v.getArtworkType()){
                    flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
                    hasArtwork += EMetaProperty.META_ARTWORK_BACKDROP.getValue();
                }
            }
        }
        return hasArtwork;
    }

}
