/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.api.model.constant.EArtworkType;
import com.valor.mfc.vms.api.model.constant.EMetaSource;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.database.model.IComparable;
import com.valor.mfc.vms.meta.model.database.constants.EMetaModifyProperty;
import com.valor.mfc.vms.meta.model.database.constants.EMetaProperty;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.mfc.vms.meta.model.database.dto.IChangedMerge;
import com.valor.mfc.vms.meta.model.database.tools.BitTools;
import com.valor.mfc.vms.meta.model.database.tools.media.Meta4QueryWrapper;
import com.valor.mfc.vms.meta.model.database.tools.media.MetaModifyFlagWrapper;
import common.base.tools.type.CollectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaMergeDto {
    private static final Logger logger = LoggerFactory.getLogger(MetaMergeDto.class);
    protected String field = "";
    protected Set<Object> toBeDelSet = Sets.newHashSet();
    protected Meta4QueryWrapper meta4QueryWrapper = null;
    protected MetaModifyFlagWrapper modifyFlagWrapper = new MetaModifyFlagWrapper();
    protected Map<String, Integer> changedMap = Maps.newHashMap();
    protected Map<String, Integer> deleteMap = Maps.newHashMap();

    public MetaMergeDto(String field) {
        this.field = field;
        this.meta4QueryWrapper = new Meta4QueryWrapper(null, field);
    }

    public void setMeta4Query(Meta4Query meta4Query) {
        this.meta4QueryWrapper = new Meta4QueryWrapper(meta4Query, this.field);
    }

    public Meta4QueryWrapper getMeta4QueryWrapper() {
        return this.meta4QueryWrapper;
    }

    public Set<Object> getToBeDelSet() {
        return this.toBeDelSet;
    }

    public void setToBeDelSet(Set<Object> toBeDelSet) {
        this.toBeDelSet = toBeDelSet;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Set mapValueAsSet(Map map) {
        return Sets.newHashSet(map.values());
    }

    public void addIfChange(Map valueMap, IComparable v, IChangedMerge change) {
        IComparable old = (IComparable)valueMap.get(v.valueKey());
        if (old == null) {
            valueMap.put(v.valueKey(), v);
            this.addChanged(v);
        } else {
            if (change != null) {
                change.onMerge(old, v);
            }
            if (old.valueEquals((Object)v)) {
                valueMap.remove(old.valueKey());
            } else {
                valueMap.replace(v.valueKey(), v);
                this.addChanged(v);
            }
        }
    }

    public void addAllIfChange(Map valueMap, Collection valueList) {
        this.addAllIfChange(valueMap, valueList, null);
    }

    public void addAllIfChange(Map valueMap, Collection valueList, IChangedMerge change) {
        if (CollectionUtils.isNullOrEmpty((Collection)valueList)) {
            return;
        }
        valueList.forEach(e -> this.addIfChange(valueMap, (IComparable)e, change));
    }

    public void setAll(Map valueMap, Collection values) {
        if (CollectionUtils.isNullOrEmpty((Collection)values)) {
            return;
        }
        values.forEach(e -> {
            IComparable v = (IComparable)e;
            v.setToBeDel(99999);
            valueMap.put(v.valueKey(), v);
        });
    }

    public void setToBeDel(Map valeMap) {
        HashSet tbdList = Sets.newHashSet();
        if (!CollectionUtils.isNullOrEmpty((Map)valeMap)) {
            for (Object e2 : valeMap.values()) {
                if (!(e2 instanceof AbstractLMI) || ((AbstractLMI)e2).getToBeDel() != 99999 || ((AbstractLMI)e2).getDataVersion() == 99999999999999L) continue;
                tbdList.add(e2);
                this.addDelete(e2);
            }
            if (!CollectionUtils.isNullOrEmpty((Collection)tbdList)) {
                tbdList.forEach(e -> valeMap.remove(((AbstractLMI)e).valueKey()));
                this.toBeDelSet.addAll(tbdList);
            }
        }
    }

    public void updateFlag(AbstractMedia v) {
        if (v != null) {
            v.setComplete(this.meta4QueryWrapper.getMetaFlag());
            v.setManual(this.modifyFlagWrapper.getFlags());
        }
    }

    public int replaceFlag(int t, int s, int flag) {
        int v = t;
        v = BitTools.isSet(s, flag) ? BitTools.setBit(t, flag) : BitTools.clsBit(t, flag);
        return v;
    }

    public void updateImageFlag(AbstractMedia v) {
        if (v == null) {
            return;
        }
        int propFlag = v.getComplete();
        propFlag = this.replaceFlag(propFlag, this.meta4QueryWrapper.getMetaFlag(), EMetaProperty.META_ARTWORK_POSTTER.getValue());
        propFlag = this.replaceFlag(propFlag, this.meta4QueryWrapper.getMetaFlag(), EMetaProperty.META_ARTWORK_BACKDROP.getValue());
        v.setComplete(propFlag);
        int manualFlag = v.getManual();
        manualFlag = this.replaceFlag(manualFlag, this.modifyFlagWrapper.getFlags(), EMetaModifyProperty.META_MODFIY_POSTTER.getValue());
        manualFlag = this.replaceFlag(manualFlag, this.modifyFlagWrapper.getFlags(), EMetaModifyProperty.META_MODIFY_BACKDROP.getValue());
        v.setManual(manualFlag);
        this.addChanged((Object)v);
    }

    public Meta4Query getMeta4Query() {
        return this.meta4QueryWrapper.getMeta4Query();
    }

    public void updateArtworkModifyFlag(Set set, MetaModifyFlagWrapper flagWrapper) {
        AbstractArtwork v;
        if (CollectionUtils.isNullOrEmpty((Collection)set)) {
            return;
        }
        for (Object e : set) {
            v = (AbstractArtwork)((Object)e);
            if (v.getSource() != EMetaSource.VXMFC || v.getMaster() != 1) continue;
            if (v.getArtworkType() == EArtworkType.POSTER) {
                if (v.getLanguage().equalsIgnoreCase("en")) {
                    flagWrapper.setFlag(EMetaModifyProperty.META_MODFIY_POSTTER);
                } else if (v.getLanguage().equalsIgnoreCase("es")) {
                    flagWrapper.setFlag(EMetaModifyProperty.META_MODFIY_POSTTER_ES);
                } else if (v.getLanguage().equalsIgnoreCase("pt")) {
                    flagWrapper.setFlag(EMetaModifyProperty.META_MODFIY_POSTTER_PT);
                }
            }
            if (v.getArtworkType() != EArtworkType.BACKDROP) continue;
            if (v.getLanguage().equalsIgnoreCase("en")) {
                flagWrapper.setFlag(EMetaModifyProperty.META_MODIFY_BACKDROP);
                continue;
            }
            if (v.getLanguage().equalsIgnoreCase("es")) {
                flagWrapper.setFlag(EMetaModifyProperty.META_MODIFY_BACKDROP_ES);
                continue;
            }
            if (!v.getLanguage().equalsIgnoreCase("pt")) continue;
            flagWrapper.setFlag(EMetaModifyProperty.META_MODIFY_BACKDROP_PT);
        }
        for (Object e : set) {
            v = (AbstractArtwork)((Object)e);
            if (v.getSource() == EMetaSource.VXMFC) continue;
            if (v.getArtworkType() == EArtworkType.POSTER && v.getMaster() == 1 && (v.getLanguage().equalsIgnoreCase("en") && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER) || v.getLanguage().equalsIgnoreCase("es") && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_ES) || v.getLanguage().equalsIgnoreCase("pt") && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_PT))) {
                v.setMaster(0);
            }
            if (v.getArtworkType() != EArtworkType.BACKDROP || v.getMaster() != 1 || !(v.getLanguage().equalsIgnoreCase("en") && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP) || v.getLanguage().equalsIgnoreCase("es") && flagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_ES)) && (!v.getLanguage().equalsIgnoreCase("pt") || !flagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_PT))) continue;
            v.setMaster(0);
        }
    }

    public void addDelete(Object o) {
        if (o == null) {
            return;
        }
        String name = o.getClass().getSimpleName();
        int v = this.deleteMap.getOrDefault(name, 0);
        this.deleteMap.put(name, v + 1);
    }

    public void addChanged(Object o) {
        if (o == null) {
            return;
        }
        String name = o.getClass().getSimpleName();
        int v = this.changedMap.getOrDefault(name, 0);
        this.changedMap.put(name, v + 1);
    }

    public String dumpSyncStat(AbstractMedia media) {
        if (media != null) {
            return this.dumpSyncStat(media.getId(), media.getImdbId(), media.getType());
        }
        return this.dumpSyncStat(0L, "x", EVideoType.UNKNOWN);
    }

    public String dumpSyncStat(long metaId, String metaId2, EVideoType type) {
        StringBuilder sb = new StringBuilder();
        sb.append("[SYNC][STAT]");
        sb.append("[").append(metaId).append("-").append(metaId2).append("-").append(type).append("-").append(this.field).append("]");
        if (!this.changedMap.isEmpty()) {
            sb.append(" Changed:[").append(Joiner.on((String)",").withKeyValueSeparator(":").join(this.changedMap)).append("]");
        }
        if (!this.deleteMap.isEmpty()) {
            sb.append(" Delete:[").append(Joiner.on((String)",").withKeyValueSeparator(":").join(this.deleteMap)).append("]");
        }
        return sb.toString();
    }

    public MetaModifyFlagWrapper getModifyFlagWrapper() {
        return this.modifyFlagWrapper;
    }

    public Set<String> getChangedTables() {
        HashSet changedSet = Sets.newHashSet();
        changedSet.addAll(this.changedMap.keySet());
        changedSet.addAll(this.deleteMap.keySet());
        return changedSet;
    }
}

