package com.valor.mfc.vms.meta.model.database.ddo.linked;

import com.google.common.base.Objects;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/6/27.
 * 所有用户linked数据全集。
 */
@Deprecated
@Entity
@Table(name="linked_meta_all"/*,
        indexes = {@Index(name = "idx_linked_meta_all_imdb_id",columnList = "imdbId"),
                   @Index(name = "idx_linked_meta_all_imdb_id",columnList = "imdbId"),
                   @Index(name = "idx_linked_meta_all_release_date",columnList = "release_date_int"),
                   @Index(name = "idx_linked_meta_all_popularity",columnList = "popularity"),
                   @Index(name = "idx_linked_meta_all_wr",columnList = "wr")}*/)
public class LinkedMetaAllDdo extends AbstractLMI{

    @Id
    @Column(name = "id")
    private long mediaId = -1;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "type")
    private EVideoType mediaype = EVideoType.UNKNOWN;

    @Column(name = "imdb_id",length = 16)
    String imdbId = "";

    @Column(name = "meta_id",length = 16)
    String metaId = "";

    @Column(name = "release_date_int",columnDefinition = "int default 0")
    int releaseDate      = 0;

    @Column(name = "popularity",columnDefinition = "int default 0")
    int popularity   = 0;

    @Column(name = "WR",columnDefinition = "int default 0")
    int weightRating = 0;

    @Column(name = "category",columnDefinition = "int default 0")
    int category = 0;

    @Column(name = "status",columnDefinition = "int default 0")
    int status = 0;

    @Column(name = "rating",columnDefinition="double(9,1) default 0.0")
    protected double rating=0.0;

    @Column(name = "publication_year",columnDefinition="int default -1")
    protected int year = -1;

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public EVideoType getMediaype() {
        return mediaype;
    }

    public void setMediaype(EVideoType mediaype) {
        this.mediaype = mediaype;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public int getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(int releaseDate) {
        this.releaseDate = releaseDate;
    }

    public int getPopularity() {
        return popularity;
    }

    public void setPopularity(int popularity) {
        this.popularity = popularity;
    }

    public int getWeightRating() {
        return weightRating;
    }

    public void setWeightRating(int weightRating) {
        this.weightRating = weightRating;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LinkedMetaAllDdo that = (LinkedMetaAllDdo) o;

        return Objects.equal(this.mediaId, that.mediaId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(mediaId);
    }
}
