package com.valor.mfc.vms.meta.model.database.ddo.linked;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.api.model.constant.EVideoType;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * File        :
 * Description :
 * Author      : Frank
 * Created     : 2015/11/29 8:30
 */
@Entity
@Table(name="linked_meta",
        indexes = {@Index(name = "idx_linked_meta_acct",columnList = "site,acct"),
                   @Index(name = "idx_linked_meta_video_id",columnList = "video_id"),
                   @Index(name = "idx_linked_meta_user_id",columnList = "user_id"),
                   @Index(name = "idx_linked_meta_user_video",columnList = "user_id,video_id")})
public class LinkedMetaDdo extends AbstractLMI {
    @Id
    @Column(name = "user_id")
    private long userId;

    @Id
    @Column(name="site",length = 16)
    String site;

    @Id
    @Column(name="acct",length = 32)
    String acct;

    @Id
    @Column(name = "checksum",length = 32)
    private String checksum;


    @Column(name="meta_id",length = 16)
    String metaId;

    @Column(name = "video_id")
    private long videoId = -1;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType = EVideoType.UNKNOWN;

    @Column(name = "season")
    private int season;

    @Column(name = "episode")
    private int episode;

    @Column(name = "quality",length = 64)
    private String quality;

    @Column(name = "format",length = 64)
    private String format;

    @Column(name = "extra",length = 1024)
    private String extra;

    @Column(name = "linked_time")
    private long LinkedTime = 0;

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAcct() {
        return acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }


    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public long getVideoId() {
        return videoId;
    }

    public void setVideoId(long videoId) {
        this.videoId = videoId;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LinkedMetaDdo that = (LinkedMetaDdo) o;

        return Objects.equal(this.checksum, that.checksum);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(checksum);
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getLinkedTime() {
        return LinkedTime;
    }

    public void setLinkedTime(long linkedTime) {
        LinkedTime = linkedTime;
    }
}



