package com.valor.mfc.vms.meta.model.database.ddo.playlist.common;

import com.google.common.base.Objects;
import com.valor.mfc.vms.api.model.constant.EDisplayType;
import com.valor.mfc.vms.api.model.constant.EPlaylistShowType;
import com.valor.mfc.vms.api.model.constant.EPlaylistStatus;
import com.valor.mfc.vms.api.model.constant.EPlaylistType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.*;


/**
 * playlist Database Data Object.
 */
@MappedSuperclass
public class AbstractPlaylist extends AbstractLMI{
	@Id
    @Column(name = "id")
    private Long id;

//    @NaturalId
    @Column(name = "name", length = 64)
    private String name;

	@Column(name = "title")
	private String title;

	@Column(name="description",length = 1024)
	private String description="";

    @Column(name = "poster")
    private String poster="";

	@Column(name="backdrop")
	private String backdrop="";

    @Column(name="show_seq")
    private int showSeq=0;    //show seq

    @Column(name="status")
    @Enumerated(EnumType.ORDINAL)
    private EPlaylistStatus status;

	@Column(name="is_vip")
	private int isVip=0;

	@Column(name="price")
	private int price=0; //price

    @Column(name="type")
    @Enumerated(EnumType.STRING)
    private EPlaylistType type;

	@Column(name="show_type")
	@Enumerated(EnumType.STRING)
	private EPlaylistShowType showType;

    @Column(name="target",length = 2000)
    private String target;

	@Column(name="can_filter")
	private int canFilter=0;

	@Column(name="extra", columnDefinition="text")
	private String extra="";

    @Column(name = "display_type")
    private String displayType;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getPoster() {
		return poster;
	}

	public void setPoster(String poster) {
		this.poster = poster;
	}

	public String getBackdrop() {
		return backdrop;
	}

	public void setBackdrop(String backdrop) {
		this.backdrop = backdrop;
	}

	public int getShowSeq() {
		return showSeq;
	}

	public void setShowSeq(int showSeq) {
		this.showSeq = showSeq;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String desc) {
		this.description = desc;
	}

	public EPlaylistStatus getStatus() {
		return status;
	}

	public void setStatus(EPlaylistStatus status) {
		this.status = status;
	}

	public void setStatusString(String statusString){
		this.status = EPlaylistStatus.fromString(statusString);
	}

	public void setStatusInt(int statusInt){
		this.status = EPlaylistStatus.valueOf(statusInt);
	}

	public int getPrice() {
		return price;
	}

	public void setPrice(int price) {
		this.price = price;
	}

	public int getIsVip() {
		return isVip;
	}

	public void setIsVip(int isVip) {
		this.isVip = isVip;
	}

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public EPlaylistType getType() {
        return type;
    }

    public void setType(EPlaylistType type) {
        this.type = type;
    }

	public EPlaylistShowType getShowType() {
		return showType;
	}

	public void setShowType(EPlaylistShowType showType) {
		this.showType = showType;
	}

	public int getCanFilter() {
		return canFilter;
	}

	public void setCanFilter(int canFilter) {
		this.canFilter = canFilter;
	}

	public String getExtra() {
		return extra;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}

    public String getDisplayType() {
        return displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    @Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		AbstractPlaylist that = (AbstractPlaylist) o;

		return Objects.equal(this.id, that.id);
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(id);
	}
}
