package com.valor.mfc.vms.meta.model.database.ddo.playlist.common;

import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.*;

/**
 * Created on 2022/2/22.
 *
 * @author Fagan Wang
 *
 * 子地区列表
 */
@Entity
@Table(name = "vms_playlist_subregion",uniqueConstraints = {@UniqueConstraint(columnNames = {"region_id","subregion_id"})})
public class PlaylistSubregionDdo extends AbstractLMI {
    private static final long serialVersionUID = -3461730289813411516L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", nullable = false)
    private Long id;

    @Column(name="region_id", columnDefinition = "varchar(32) default 'default'")
    private String regionId;

    @Column(name="subregion_id", columnDefinition = "varchar(32) default 'default'")
    private String subregionId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getSubregionId() {
        return subregionId;
    }

    public void setSubregionId(String subregionId) {
        this.subregionId = subregionId;
    }
}
