package com.valor.mfc.vms.meta.model.database.ddo.playlist.common;

import com.google.common.base.Objects;

import com.valor.mfc.vms.api.model.tag.ETagContentType;
import com.valor.mfc.vms.api.model.tag.ETagPostion;
import com.valor.mfc.vms.api.model.tag.ETagType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/7/9.
 */
@Entity
@Table(name = "vms_playlist_tag")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PlaylistTagDdo extends AbstractLMI {
    @Id
    @Column(name = "pid")
    public Long pid = -1L;

    @Id
    @Column(name = "position")
    @Enumerated(EnumType.STRING)
    public ETagPostion postion;

    @Id
    @Column(name = "seq")
    public int seq;

    @Id
    @Column(name = "app_id", length = 128)
    private String appId = "";

    @Id
    @Column(name = "release_id", length = 128)
    private String releaseId = "";

    @Column(name = "type")
    @Enumerated(EnumType.STRING)
    private ETagType type;

    @Column(name = "content_type")
    @Enumerated(EnumType.STRING)
    private ETagContentType contentType;

    @Column(name = "content", length = 512)
    private String content = "";

    @Column(name = "content_from", length = 512)
    private String contentFrom = "";

    @Column(name = "content_filter", length = 2048)
    private String contentFilter = "";

    @Column(name = "ACL", length = 256)
    private String ACL = "";

    //0:all 1:only box 2:only mobile
    @Column(name = "client_type", columnDefinition = "INT default 0")
    private int clientType = 0;

    /**
     * 2.3版本增加，数据类型，
     */
    @Column(name = "data_type",length = 128)
    private String dataType = "";

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public ETagPostion getPostion() {
        return postion;
    }

    public void setPostion(ETagPostion postion) {
        this.postion = postion;
    }

    public int getSeq() {
        return seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public ETagType getType() {
        return type;
    }

    public void setType(ETagType type) {
        this.type = type;
    }

    public ETagContentType getContentType() {
        return contentType;
    }

    public void setContentType(ETagContentType contentType) {
        this.contentType = contentType;
    }

    public String getContentFrom() {
        return contentFrom;
    }

    public void setContentFrom(String contentFrom) {
        this.contentFrom = contentFrom;
    }

    public String getContentFilter() {
        return contentFilter;
    }

    public void setContentFilter(String contentFilter) {
        this.contentFilter = contentFilter;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getACL() {
        return ACL;
    }

    public void setACL(String ACL) {
        this.ACL = ACL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PlaylistTagDdo that = (PlaylistTagDdo) o;
        return seq == that.seq &&
                Objects.equal(pid, that.pid) &&
                postion == that.postion;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(pid, postion, seq);
    }


    public int getClientType() {
        return clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}
