package com.valor.mfc.vms.meta.model.database.ddo.playlist.common;

import com.google.common.base.Objects;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * play list and media file referance table
 * @author Frank
 *
 */
@Entity
@Embeddable
@Table(name = "vms_playlist_videos",
       uniqueConstraints = @UniqueConstraint(name = "UIX_PLAYLIST_MEDIA", 
       columnNames = {"playlist_id", "video_id","video_type", "show_seq"})
)
@SuppressWarnings("unused")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PlaylistVideosDDO extends AbstractLMI{
	private static final long serialVersionUID = 1L;
	@Id
	@Column(name="playlist_id")
	public long playlistId; //play list id

	@Id
	@Column(name="video_id")
	public long videoId;//media file id

	@Id
	@Column(name="video_type")
	@Enumerated(EnumType.ORDINAL)
	public EVideoType videoType;

	@Column(name="show_seq")
	private long showSeq;  //order in playlist

	@Column(name="status")
	private int status=0;

    /**
     * 3.0版本新增布局选择，默认为空
     */
    @Column(name = "layout", columnDefinition = "varchar(255) default '' COMMENT '布局格式'")
    private String layout;


	//Getter and Setter
	public long getPlaylistId() {
		return playlistId;
	}

	public void setPlaylistId(long playlistId) {
		this.playlistId = playlistId;
	}

	public long getShowSeq() {
		return showSeq;
	}

	public void setShowSeq(long showSeq) {
		this.showSeq = showSeq;
	}

	public long getVideoId() {
		return videoId;
	}

	public void setVideoId(long videoId) {
		this.videoId = videoId;
	}

	public EVideoType getVideoType() {
		return videoType;
	}

	public void setVideoType(EVideoType videoType) {
		this.videoType = videoType;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

    public String getLayout() {
        return layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    @Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		PlaylistVideosDDO that = (PlaylistVideosDDO) o;

		return Objects.equal(this.playlistId, that.playlistId) &&
				Objects.equal(this.videoId, that.videoId) &&
				Objects.equal(this.videoType, that.videoType);
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(playlistId, videoId, videoType);
	}

	@Override
	public String valueKey() {
		return DdoKeyTools.key(playlistId,videoId,videoType);
	}

	@Override
	public boolean valueEquals(Object o) {
		if (!equals(o)) {
			return false;
		} else {
			PlaylistVideosDDO that = (PlaylistVideosDDO) o;

			return Objects.equal(this.showSeq,that.showSeq)
					&& Objects.equal(this.status,that.status);
		}
	}
}
