package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.valor.mfc.vms.meta.model.database.ddo.cloud.CloudAudioLanguageDdo;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;

import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;

@Service
public class CloudAudioLanguageService {
    private static Map<Integer,String> codeLanguageMap = Maps.newHashMap();
    private static Map<String,Integer> languageCodeMap = Maps.newHashMap();
    @Autowired
    private MetaDao metaDao;
    @PostConstruct
    public void load(){
        Set<CloudAudioLanguageDdo> audioLanguageDdos = metaDao.getSetData(false,CloudAudioLanguageDdo.class,null);
        audioLanguageDdos.forEach(e->{
            codeLanguageMap.put(e.getCode(),e.getLanguage());
            languageCodeMap.put(e.getLanguage(),e.getCode());
        });
    }

    /**
     * convert language list to a long number
     * support 64 languages,language code is between 1 to 63,64 is sign
     * @param languages
     * @return
     */
    public long languages2Num(List<String> languages){
        BitSet bitSet = new BitSet();
        languages.forEach(e->{
            if(languageCodeMap.containsKey(e)){
                int index = languageCodeMap.get(e)-1;
                if (index >= 0 && index<64){
                    BitSet languageBitSet = new BitSet();
                    languageBitSet.set(index);
                    bitSet.or(languageBitSet);
                }
            }
        });
        long[] bits = bitSet.toLongArray();
        return bits.length>0?bits[0]:0;
    }

    /**
     * explain the number to the language list
     * @param languageNum
     * @return
     */
    public List<String> num2Languages(long languageNum){
        List<String> languages = Lists.newArrayList();
        String binaryString = Long.toBinaryString(languageNum);
        char[] languageChars = binaryString.toCharArray();
        int code = 1;
        for(int i = languageChars.length-1;i>0;i--){
            if('1'==languageChars[i]&&codeLanguageMap.containsKey(code)){
                String language = codeLanguageMap.get(code);
                languages.add(language);
            }
            code++;
        }
        return languages;
    }
}
