/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.mfc.vms.api.model.constant.JobType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AbstractCastCrew
extends AbstractLMI {
    @Id
    @Column(name="media_id")
    public long mediaId;
    @Id
    @Column(name="person_id")
    public long personId;
    @Id
    @Column(name="job")
    public JobType jobType;
    @Column(name="role", length=1023)
    protected String role;
    @Column(name="ordering", nullable=false)
    protected int ordering = 0;

    public boolean isValid() {
        if (this.mediaId < 1L) {
            return false;
        }
        if (this.personId < 1L) {
            return false;
        }
        return this.jobType == JobType.DIRECTOR || this.jobType == JobType.ACTOR || this.jobType == JobType.WRITER;
    }

    public Long getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public void setOrdering(int ordering) {
        this.ordering = ordering;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public long getPersonId() {
        return this.personId;
    }

    public void setPersonId(long personId) {
        this.personId = personId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractCastCrew that = (AbstractCastCrew)((Object)o);
        return Objects.equal((Object)this.mediaId, (Object)that.mediaId) && Objects.equal((Object)this.personId, (Object)that.personId) && Objects.equal((Object)this.jobType, (Object)that.jobType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mediaId, this.personId, this.jobType});
    }

    public String valueKey() {
        return DdoKeyTools.key((Object[])new Object[]{this.mediaId, this.personId, this.jobType});
    }

    public boolean valueEquals(Object o) {
        if (!this.equals(o)) {
            return false;
        }
        AbstractCastCrew that = (AbstractCastCrew)((Object)o);
        return Objects.equal((Object)this.role, (Object)that.role) && Objects.equal((Object)this.ordering, (Object)that.ordering);
    }
}

