package com.valor.mfc.vms.meta.model.database.dao.query.filter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import com.valor.mfc.vms.api.model.constant.EPlaylistType;
import com.valor.mfc.vms.api.model.filter.FilterHelper;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.alias.MovieQueryAlias;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.alias.SqlQueryAlias;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.FilterTools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2016/1/2 19:04
 */
public class SqlQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlQueryBuilder.class);
    private static int    FIELD_SIZE = 3;
    private static String FIELD_SPLIT = ":";
    private static String VALUE_SPLIT = ",";
    private static String ITEM_SPLIT  = ";";
    
    private int      filterLinked = 0;
    private int      linked       = 0;
    private long     userId       = 0;
    private long     pid          = -1;
    private long     appVer = -1;
    private boolean isIllegalLocation = false;
    private String   filter       = "";
    private String   selectTable  = "";
    private EPlaylistType plType;
    private String plTarget = "";
    private SqlQueryAlias queryAlias = null;
    private List<Long> cids;

    private StringBuilder fieldsCause = new StringBuilder("");
    private StringBuilder fromCause   = new StringBuilder("");
    private StringBuilder joinCause   = new StringBuilder("");
    private StringBuilder whereCause  = new StringBuilder("");
    private Set<FilterField> filterFields = Sets.newHashSet();
    private Map<String,String> parameters = Maps.newHashMap();
    private Set<String> parameterKeySet   = Sets.newHashSet();

    public static boolean isValidKey(String key){
        if ((FilterHelper.FILTER_GENRE.compareToIgnoreCase(key)!=0)
            && (FilterHelper.FILTER_COUNTRY.compareToIgnoreCase(key)!=0)
            && (FilterHelper.FILTER_RATING.compareToIgnoreCase(key)!=0)
            && (FilterHelper.FILTER_RELEASE_YEAR.compareToIgnoreCase(key)!=0)
            && (FilterHelper.FILTER_RELEASE_DATE.compareToIgnoreCase(key)!=0)){
            return false;
        }

        return true;
    }

    public static String getSqlOperator(String opCode){
        return FilterHelper.getSqlOperator(opCode);
    }

    public SqlQueryBuilder(SqlQueryAlias queryAlias,
                           Long uid,
                           int linked,
                           String filter,
                           EPlaylistType plType,
                           Long pid,
                           Map<String,String> parameters,
                           long appVer,
                           boolean isIllegalLocation,
                           List<Long> cids){
        if (!CollectionUtils.isNullOrEmpty(parameters)){
            this.parameters = parameters;
        }
        this.parameters = parameters;
        this.queryAlias = queryAlias;
        this.filter     = filter;
        this.linked     = linked;
        this.userId     = uid;
        this.plType     = plType;
        this.pid        = pid;
        this.plTarget   = this.parameters.getOrDefault(FilterUtil.KEY_FILTER,"");
        this.appVer = appVer;
        this.isIllegalLocation = isIllegalLocation;

        if (!Strings.isNullOrEmpty(plTarget)){
            this.filter += plTarget;
        }

        if (this.linked == 1){
            selectTable = SqlQueryAlias.TABLE_META_LINKED;
        }else {
            selectTable = SqlQueryAlias.TABLE_META;
        }
        this.cids = cids;
        generateFilterSql();
    }

    private void parseFilterString(){
        if (filter == null){
            return;
        }

        /**
         * filter的格式为：key1:v1;hb:in;key2:v3;
         */
        List<String> metaStrs = Splitter.on(ITEM_SPLIT).omitEmptyStrings()
                                .trimResults().splitToList(filter);
        for (String item:metaStrs){
            if (item.isEmpty()){
                return;
            }

            List<String> fields = Splitter.on(FIELD_SPLIT).omitEmptyStrings().trimResults().splitToList(item);
            if (fields.size() <2){
                logger.warn("Invalid filter item:{}",item);
                continue;
            }

            if (fields.get(1).isEmpty()){
                logger.warn("value is empty filter key");
                continue;
            }

            FilterField filterField  = new FilterField();
            filterField.setKey(fields.get(0));

            List<String> values = Splitter.on(VALUE_SPLIT)
                    .omitEmptyStrings()
                    .trimResults()
                    .splitToList(fields.get(1));

            values.forEach(e->filterField.addValue(e));

            if (fields.size() > 2){
                filterField.setOperator(getSqlOperator(fields.get(2)));
            }else {
                filterField.setOperator(FilterHelper.SQL_EQ);
            }

            filterFields.add(filterField);
            if (filterField.getKey().equalsIgnoreCase(FilterHelper.FILTER_LINKED)){
                filterLinked = Integer.valueOf((String) filterField.getValues().toArray()[0]);
            }
        }
    }

    private void generateFilterSql(){
        parseFilterString();

        appendFromCause(selectTable);
        whereCause.append(selectTable+".type in ( #{tfv_media_type} )");
        whereCause.append(" and "+ selectTable + ".adult=0");
        whereCause.append(" and "+ selectTable + ".disable=0");

        if (plType == EPlaylistType.PLAYLIST){
            appendFromCause(",vms_playlist_videos");

            if (whereCause.length() > 0){
                whereCause.append(FilterHelper.SQL_AND);
            }
            whereCause.append(selectTable+".id in (select video_id from vms_playlist_videos where playlist_id=");
            whereCause.append(pid);
            whereCause.append(")");
        }

        if (linked == 1){
//            whereCause.append(" and "+ selectTable +".linked!=0");
            whereCause.append(" and "+ selectTable +".id in( ");
            whereCause.append(SqlQueryAlias.getUserLinkedSql(cids));
            if (FilterUtil.LINK_FORMAT_3D.compareToIgnoreCase(parameters.getOrDefault(FilterUtil.KEY_LINKED_FORMAT,""))==0){
                whereCause.append(" and format='3d'");
            }
            whereCause.append(")");
        }

        if (filterLinked == 0 && linked == 0){
            if (FilterUtil.TIME_LIMIT_NO.compareToIgnoreCase(parameters.getOrDefault(FilterUtil.KEY_TIME_LIMIT,""))!=0){
                if (queryAlias instanceof MovieQueryAlias){
                    whereCause.append(" and(" + selectTable + ".release_date_int<=").append(DateTimeTools.distanceTodayByMonthInt(-2));
                    whereCause.append(" or " + selectTable +".linked!=0)");
                }
            }
        }

        filterFields.forEach(e->{
            String filter = FilterTools.buildQueryFilter(e);
            if (!Strings.isNullOrEmpty(filter)){
                if (whereCause.length() > 0){
                    whereCause.append(FilterHelper.SQL_AND);
                }
                whereCause.append(filter);
            }
        });
    }


    public void addFilterField(String field){
        if (fieldsCause.length() > 0){
            fieldsCause.append(",");
        }

        fieldsCause.append(field);
    }

    public String buildQuerySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(fieldsCause);
        sb.append(" from ");
        sb.append(fromCause);
        if (joinCause.length() > 0 || whereCause.length()> 0){
            sb.append(" where ");
            sb.append(joinCause);
            if(joinCause.length()>0){
                sb.append(FilterHelper.SQL_AND);
            }
            sb.append(whereCause);
        }

        String sql = sb.toString();
        return queryAlias.replaceAlias(sql);

    }

    private void appendFromCause(String str) {
        fromCause.append(str);
    }
}
