package com.valor.mfc.vms.meta.model.database.ddo.media.common;

import com.valor.mfc.vms.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@Entity
@Table(name = "vms_meta_tag")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MetaTag extends AbstractLMI {
    @Id
    @Column(name="tag_id",columnDefinition="varchar(20) COMMENT '标签ID'")
    private String tagId;
    @Column(name="en_tag",nullable=false,columnDefinition="varchar(255) COMMENT 'en标签'")
    private String enTag;
    @Column(name="category",nullable=false,columnDefinition="int(11) COMMENT '1 channel, 2 plot keyword'")
    private int category;
    @Column(name="show_seq",columnDefinition="int(11) COMMENT '排序值'")
    private int showSeq;
    @Column(name="mark",columnDefinition="varchar(255) COMMENT 'en标记'")
    private String mark;

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getEnTag() {
        return enTag;
    }

    public void setEnTag(String enTag) {
        this.enTag = enTag;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getShowSeq() {
        return showSeq;
    }

    public void setShowSeq(int showSeq) {
        this.showSeq = showSeq;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
