package com.valor.mfc.vms.meta.model.database.dao.query.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;

import com.valor.mfc.vms.meta.model.database.dao.query.filter.alias.SqlOrderAlias;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.alias.SqlQueryAlias;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Created by Frank.Huang on 2016/4/21.
 */
public class SqlOrderBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlQueryBuilder.class);

    private static String FIELD_SPLIT = ":";
    private static String ITEM_SPLIT  = ";";

    private Map<String,String> orderByMap = Maps.newHashMap();
    private Map<String,String> orderByField = Maps.newHashMap();

    private String playlistOrder = "";
    private String searchOrder   = "";
    private String orginStr      = "";
    private SqlQueryAlias queryAlias;
    private int linked           = 0;

    public SqlOrderBuilder(int linked,
                           SqlQueryAlias queryAlias,
                           String searchOrder,
                           String playlistOrder) {
        this.playlistOrder = playlistOrder;
        this.searchOrder = searchOrder;
        this.queryAlias = queryAlias;
        this.orginStr = searchOrder + playlistOrder;
        this.linked = linked;

    }

    public String buildOrderSql(){

        orderByMap = Splitter.on(';').omitEmptyStrings().withKeyValueSeparator(":").split(this.orginStr);
        if (!orderByMap.isEmpty()){
            orderByMap.forEach((k,v)->{
                String field = SqlOrderAlias.getSortField(linked,k);
                if (Strings.isNullOrEmpty(field)){
                    logger.info("Invalid sort arg.!!!{}:{}",k,v);
                }else {
                    orderByField.put(field,v);
                }
            });
        }

        String sqlOrderWithAlias = "";
        String orderBy = Joiner.on(',').withKeyValueSeparator(" ").join(orderByField);
        if (!Strings.isNullOrEmpty(orderBy)){
            sqlOrderWithAlias = Joiner.on(' ').skipNulls().join("order by",orderBy);
        }else {
            if (linked == 1){
                sqlOrderWithAlias = "order by #{tab_meta_link}.release_date_int desc";
            }else {
                sqlOrderWithAlias = "order by #{tab_meta}.release_date_int desc";
            }

        }

        return queryAlias.replaceAlias(sqlOrderWithAlias);
    }


}
