package com.valor.mfc.vms.meta.model.database.ddo.company;

import com.valor.mfc.vms.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

@Entity
@Table(name = "vms_company",indexes={@Index(name="coIdIndex",columnList="co_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Company extends AbstractLMI {

    @Id
    @Column(name="co_id",nullable=false,columnDefinition="varchar(16) COMMENT 'company编号'")
    private String coId;
    @Column(name="name",columnDefinition="varchar(127) default '' COMMENT '名字'")
    private String name;
    @Column(name="types",columnDefinition="varchar(127) default '' COMMENT '类型,多类型逗号分割'")
    private String types;
    @Column(name="country",columnDefinition="varchar(16) default '' COMMENT '国家地区简码'")
    private String country;

    public String getCoId() {
        return coId;
    }

    public void setCoId(String coId) {
        this.coId = coId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypes() {
        return types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

}
