package com.valor.mfc.vms.meta.model.database.ddo.media;

import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractId;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/8/16.
 */
@Entity
@Table(name = "vms_meta_for_query"
/*indexes = {@Index(name = "idx_media4query_basequery",columnList = "type,adult,disable,has_artwork,rating"),
        @Index(name = "idx_media4query_meta_id",columnList = "meta_id"),
        @Index(name = "idx_media4query_meta_is_animation",columnList = "is_animation"),
        @Index(name = "idx_media4query_meta_is_family",columnList = "is_family"),
        @Index(name = "idx_media4query_meta_is_hollywood",columnList = "is_hollywood"),
        @Index(name = "idx_media4query_meta_is_latin",columnList = "is_latin"),
        @Index(name = "idx_media4query_meta_linked",columnList = "linked"),
        @Index(name = "idx_media4query_meta_publication_year",columnList = "publication_year"),
        @Index(name = "idx_media4query_meta_popularity",columnList = "popularity"),
        @Index(name = "idx_media4query_meta_rating",columnList = "rating"),
        @Index(name = "idx_media4query_meta_WR",columnList = "WR"),
        @Index(name = "idx_media4query_meta_release_date_int",columnList = "release_date_int"),
        @Index(name = "idx_media4query_meta_linkedTime",columnList = "linked_time")
}*/
)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Meta4Query extends AbstractId {
    @Enumerated(EnumType.ORDINAL)
    @Column(name="type")
    private EVideoType type;

    @Column(name ="meta_id",length = 16)
    private String metaId="";

    @Column(name = "release_date_int",columnDefinition = "int default 0")
    private int releaseDate      = 0;

    @Column(name = "popularity",columnDefinition = "int default 0")
    private long popularity   = 0L;

    @Column(name = "WR",columnDefinition = "int default 0")
    private int weightRating = 0;

    @Column(name = "rating",columnDefinition = "int default 0")
    private int rating=0;

    @Column(name = "publication_year",columnDefinition="int default 0")
    private int year = 0;

    @Column(name = "linked",columnDefinition="int default 0")
    private int linked = 0;

    @Column(name = "linked_time",columnDefinition="bigint default 0")
    private long linkedTime = 0L;

    @Column(name = "disable",columnDefinition="int default 0")
    private int disable;

    @Column(name = "vote_count",columnDefinition="int default 0")
    private int voteCount=0;

    @Column(name = "adult",columnDefinition="int default 0")
    private int adult=0;

    @Column(name = "is_hollywood",columnDefinition="int default 0")
    private int isHollywood = 0;

    @Column(name = "is_latin",columnDefinition="int default 0")
    private int isLatin = 0;

    @Column(name = "is_asia",columnDefinition="int default 0")
    private int isAsia = 0;

    @Column(name = "is_3d",columnDefinition="int default 0")
    private int is3D = 0;

    @Column(name = "is_family",columnDefinition="int default 0")
    private int isFamily = 0;

    @Column(name = "is_animation",columnDefinition="int default 0")
    private int isAnimation = 0;

    @Column(name = "has_runtime",columnDefinition="int default 0")
    private int hasRuntime = 0;

    @Column(name = "has_artwork",columnDefinition="int default 0")
    private int hasArtwork = 0;

    @Column(name = "status",columnDefinition = "int default 0")
    int status = 0;

    @Column(name = "is_reserve1",columnDefinition="int default 0")
    private int langNotContainsEn = 0;

    @Column(name = "is_reserve2",columnDefinition="int default 0")
    private int isReserve2 = 0;

    @Column(name = "is_reserve3",columnDefinition="int default 0")
    private int isReserve3 = 0;

    @Column(name = "has_reserve1",columnDefinition="int default 0")
    private int lastAirDate = 0;

    @Column(name = "has_reserve2",columnDefinition="int default 0")
    private int hasReserve2 = 0;

    @Column(name = "has_reserve3",columnDefinition="int default 0")
    private int hasReserve3 = 0;

    public EVideoType getType() {
        return type;
    }

    public void setType(EVideoType type) {
        this.type = type;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public int getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(int releaseDate) {
        this.releaseDate = releaseDate;
    }

    public long getPopularity() {
        return popularity;
    }

    public void setPopularity(long popularity) {
        this.popularity = popularity;
    }

    public int getWeightRating() {
        return weightRating;
    }

    public void setWeightRating(int weightRating) {
        this.weightRating = weightRating;
    }

    public int getRating() {
        return rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public long getLinkedTime() {
        return linkedTime;
    }

    public void setLinkedTime(long linkedTime) {
        this.linkedTime = linkedTime;
    }

    public int getDisable() {
        return disable;
    }

    public void setDisable(int disable) {
        this.disable = disable;
    }

    public int getIsHollywood() {
        return isHollywood;
    }

    public void setIsHollywood(int isHollywood) {
        this.isHollywood = isHollywood;
    }

    public int getIsLatin() {
        return isLatin;
    }

    public void setIsLatin(int isLatin) {
        this.isLatin = isLatin;
    }

    public int getIsAsia() {
        return isAsia;
    }

    public void setIsAsia(int isAsia) {
        this.isAsia = isAsia;
    }

    public int getIs3D() {
        return is3D;
    }

    public void setIs3D(int is3D) {
        this.is3D = is3D;
    }

    public int getIsFamily() {
        return isFamily;
    }

    public void setIsFamily(int isFamily) {
        this.isFamily = isFamily;
    }

    public int getIsAnimation() {
        return isAnimation;
    }

    public void setIsAnimation(int isAnimation) {
        this.isAnimation = isAnimation;
    }

    public int getHasRuntime() {
        return hasRuntime;
    }

    public void setHasRuntime(int hasRuntime) {
        this.hasRuntime = hasRuntime;
    }

    public int getHasArtwork() {
        return hasArtwork;
    }

    public void setHasArtwork(int hasArtwork) {
        this.hasArtwork = hasArtwork;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getVoteCount() {
        return voteCount;
    }

    public void setVoteCount(int voteCount) {
        this.voteCount = voteCount;
    }

    public int getAdult() {
        return adult;
    }

    public void setAdult(int adult) {
        this.adult = adult;
    }

    public int getLangNotContainsEn() {
        return langNotContainsEn;
    }

    public void setLangNotContainsEn(int langNotContainsEn) {
        this.langNotContainsEn = langNotContainsEn;
    }

    public int getIsReserve2() {
        return isReserve2;
    }

    public void setIsReserve2(int isReserve2) {
        this.isReserve2 = isReserve2;
    }

    public int getIsReserve3() {
        return isReserve3;
    }

    public void setIsReserve3(int isReserve3) {
        this.isReserve3 = isReserve3;
    }

    public int getLastAirDate() {
        return lastAirDate;
    }

    public void setLastAirDate(int lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    public int getHasReserve2() {
        return hasReserve2;
    }

    public void setHasReserve2(int hasReserve2) {
        this.hasReserve2 = hasReserve2;
    }

    public int getHasReserve3() {
        return hasReserve3;
    }

    public void setHasReserve3(int hasReserve3) {
        this.hasReserve3 = hasReserve3;
    }

    public void setIfChanged(int source, int target){
        if (source != target){
            this.setToBeDel(0);
            source = target;
        }
    }

    public void setIfChanged(long source, long target){
        if (source != target){
            this.setToBeDel(0);
            source = target;
        }
    }

}
